/*
 Menu configuration file for NEW CuMX alternative website template
 Last modified: 2024/12/05
 aw-menu.js - typical name, you define the one used in setpagedata.js

 It is STRONGLY RECOMMENDED that if you customise this file, you create a new file with a different name, e.g. mymenu.js
 and change setpagedata.js to use that file. This will avoid your customisations being accidentally overwritten during upgrades

 Properties:
   .title			 - This is what appears in the displayed menu.  Note that it can contain html.
   .icon             - Font Awsome icon to use or ommitted is none required - use both classes from Font Awsome
   .menu             - can be 'b' (both menus), 'w' (wide menu ONLY), 'n' (narrow menu ONLY)
   .url				 - This is the html address of the required page.  If it is external it will need to be the
					   FULL url starting with http....
					   It can be a '_' character in which case it will be replaced with a menu bar to separate
					   sections of your drop down.  ONLY use in sub-menus.
   .new_window:true  - forces the link to open in new browser window
   .forum:true       - flags a forum link menu item, it will use the url provided in CuMX config, if that is blank the menu item will be hidden
   .webcam:true      - flags a webcam link menu item, it will use the url provided in CuMX config, if that is blank the menu item will be hidden
*/

menuSrc = [
	{title: "Dashboard",    menu: "b",    url: "index.html"},
	{title: "Today",        menu: "b",    url: "today.html"},
	{title: "Yesterday",    menu: "b",    url: "yesterday.html"},
	{title: "Today v Yesterday",   menu: "b",    url: "todayVyest.html"},
	{title: "Gauges",       menu: "b",    url: "gauges.html"},
	{title: "Records",      menu: "b",    submenu: true,       items: [
		{title: "This Month",        menu: "b",    url: "recordsthismonth.html",    icon: "fa-solid fa-list"},
		{title: "This Year",         menu: "b",    url: "recordsthisyear.html",     icon: "fa-solid fa-list-ul"},
		{title: "All Time",          menu: "b",    url: "recordsalltime.html",      icon: "fa-solid fa-list"},
		{title: "Monthly",           menu: "b",    url: "recordsmonthly.html",      icon: "fa-solid fa-list"},
		{title: "",					 menu: "b",	   url: "_"},
		{title:	"All records",		 menu: "b",	   url: "records.html",             icon: "fa-solid fa-list"}
	]},
	{title: "Charts",       menu: "b",    submenu: true,    items: [
		{title: "Trends",            menu: "b",    url: "chartstrends.html",    icon: "fa-solid fa-chart-line"},
		{title: "Select-a-graph",    menu: "b",    url: "chartsselect.html",    icon: "fa-solid fa-chart-line"},
		{title: "Historic",          menu: "b",    url: "chartshistoric.html",  icon: "fa-solid fa-chart-column"}
	]},
	{title: "Reports",   menu: "b",    url: "noaareports.html"},
	{title: "Forum",     menu: "b",    url: "#",    forum: true,    new_window: true},
	{title: "Webcam",    menu: "b",    url: "#",    webcam: false, icon: "fa-solid fa-camera"}
];