﻿/*!
 * Name          : steelseries.js
 * Authors       : Gerrit Grunwald, Mark Crossley
 * Last modified : 30.01.2015
 * Revision      : 0.14.13
 *
 * Copyright (c) 2011, Gerrit Grunwald, Mark Crossley
 * All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *
 *  # Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *  # Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided with the distribution.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 *   BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 *   SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 *   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *   OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
var steelseries=function(){function kt(t,i,r,u,f){var c=1/255,e=t.getRed(),o=t.getGreen(),s=t.getBlue(),h=t.getAlpha(),p=i.getRed()-e,w=i.getGreen()-o,b=i.getBlue()-s,k=i.getAlpha()*c-h*c,l=p/r*u,a=w/r*u,v=b/r*u,y=k/r*u;return f=f||!1,f?[(e+l).toFixed(0),(o+a).toFixed(0),(s+v).toFixed(0),h+y]:new n((e+l).toFixed(0),(o+a).toFixed(0),(s+v).toFixed(0),h+y)}function gi(n,t,i){return{start:n,stop:t,color:i}}function k(n,t){var r=Math.floor(Math.log10(n)),i=n/Math.pow(10,r),u;return u=t?1.5>i?1:3>i?2:7>i?5:10:1>=i?1:2>=i?2:5>=i?5:10,u*Math.pow(10,r)}function dt(n,t,i,r,u,f){var e=t+r,o=i+u;n.beginPath();n.moveTo(t+f,i);n.lineTo(e-f,i);n.quadraticCurveTo(e,i,e,i+f);n.lineTo(e,i+u-f);n.quadraticCurveTo(e,o,e-f,o);n.lineTo(t+f,o);n.quadraticCurveTo(t,o,t,o-f);n.lineTo(t,i+f);n.quadraticCurveTo(t,i,t+f,i);n.closePath()}function r(n,t){var i=d.createElement("canvas");return i.width=n,i.height=t,i}function ii(n,t,i){var r=d.createElement("canvas");return r.width=n,r.height=t,i(r.getContext("2d")),r}function rt(n){var t,i=ii(1,1,function(t){t.fillStyle=n;t.beginPath();t.rect(0,0,1,1);t.fill()});return t=i.getContext("2d").getImageData(0,0,2,2).data,[t[0],t[1],t[2],t[3]]}function ei(t){var u,f,e,o,s,r=rt(t),i=new n(r[0],r[1],r[2],r[3]);return u=oi(i,.32),f=oi(i,.62),e=ri(i,.84),o=ri(i,.94),s=ri(i,1),new y(u,f,i,e,o,s)}function st(n,t,i){var r,u,f,h=Math.floor(n*6),c=n*6-h,e=i*(1-t),o=i*(1-c*t),s=i*(1-(1-c)*t);switch(h%6){case 0:r=i;u=s;f=e;break;case 1:r=o;u=i;f=e;break;case 2:r=e;u=i;f=s;break;case 3:r=e;u=o;f=i;break;case 4:r=s;u=e;f=i;break;case 5:r=i;u=e;f=o}return[Math.floor(r*255),Math.floor(u*255),Math.floor(f*255)]}function ot(n,t,i){var e,r,u,o,s,f;if(n=n/255,t=t/255,i=i/255,r=Math.max(n,t,i),e=Math.min(n,t,i),s=r,f=r-e,o=r===0?0:f/r,r===e)u=0;else{switch(r){case n:u=(t-i)/f+(t<i?6:0);break;case t:u=(i-n)/f+2;break;case i:u=(n-t)/f+4}u/=6}return[u,o,s]}function p(n,t){return n<0?0:n>t?t:n}function oi(t,i){var r=Math.floor(t.getRed()*(1-i)),u=Math.floor(t.getGreen()*(1-i)),f=Math.floor(t.getBlue()*(1-i));return r=p(r,255),u=p(u,255),f=p(f,255),new n(r,u,f,t.getAlpha())}function ri(t,i){var r=Math.round(t.getRed()*(1+i)),u=Math.round(t.getGreen()*(1+i)),f=Math.round(t.getBlue()*(1+i));return r=p(r,255),u=p(u,255),f=p(f,255),new n(r,u,f,t.getAlpha())}function nr(n,t,i){var r,u;if(i<=t)throw"Rotary bounds are of negative or zero size";return r=i-t,u=Math.floor((n-t)/r),n-u*r}function si(n,t){return nr(t-n,-180,180)}function ht(n){var t=typeof n=="string"||n instanceof String?d.getElementById(n):n;return t.getContext("2d")}var i=Math.PI*.5,t=Math.PI*2,o=Math.PI,c=Math.PI/180,pt=180/Math.PI,d=document,wt="LCDMono2Ultra,Arial,Verdana,sans-serif",s="Arial,Verdana,sans-serif",hi=function(n,u){var yi;u=u||{};var vt=undefined===u.gaugeType?steelseries.GaugeType.TYPE4:u.gaugeType,f=undefined===u.size?0:u.size,h=undefined===u.minValue?0:u.minValue,b=undefined===u.maxValue?h+100:u.maxValue,ve=undefined===u.niceScale?!0:u.niceScale,gt=undefined===u.threshold?(b-h)/2+h:u.threshold,ti=undefined===u.thresholdRising?!0:u.thresholdRising,ci=undefined===u.section?null:u.section,li=undefined===u.area?null:u.area,vu=undefined===u.titleString?"":u.titleString,yu=undefined===u.unitString?"":u.unitString,pu=undefined===u.frameDesign?steelseries.FrameDesign.METAL:u.frameDesign,wu=undefined===u.frameVisible?!0:u.frameVisible,ai=undefined===u.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:u.backgroundColor,bu=undefined===u.backgroundVisible?!0:u.backgroundVisible,oi=undefined===u.pointerType?steelseries.PointerType.TYPE1:u.pointerType,ku=undefined===u.pointerColor?steelseries.ColorDef.RED:u.pointerColor,ye=undefined===u.knobType?steelseries.KnobType.STANDARD_KNOB:u.knobType,vi=undefined===u.knobStyle?steelseries.KnobStyle.SILVER:u.knobStyle,di=undefined===u.lcdColor?steelseries.LcdColor.STANDARD:u.lcdColor,iu=undefined===u.lcdVisible?!0:u.lcdVisible,du=undefined===u.lcdDecimals?2:u.lcdDecimals,pe=undefined===u.digitalFont?!1:u.digitalFont,gu=undefined===u.fractionalScaleDecimals?1:u.fractionalScaleDecimals,ru=undefined===u.ledColor?steelseries.LedColor.RED_LED:u.ledColor,uu=undefined===u.ledVisible?!0:u.ledVisible,fu=undefined===u.userLedColor?steelseries.LedColor.GREEN_LED:u.userLedColor,eu=undefined===u.userLedVisible?!1:u.userLedVisible,nf=undefined===u.thresholdVisible?!0:u.thresholdVisible,ou=undefined===u.minMeasuredValueVisible?!1:u.minMeasuredValueVisible,su=undefined===u.maxMeasuredValueVisible?!1:u.maxMeasuredValueVisible,tf=undefined===u.foregroundType?steelseries.ForegroundType.TYPE1:u.foregroundType,rf=undefined===u.foregroundVisible?!0:u.foregroundVisible,uf=undefined===u.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:u.labelNumberFormat,rr=undefined===u.playAlarm?!1:u.playAlarm,ff=undefined===u.alarmSound?!1:u.alarmSound,we=undefined===u.customLayer?null:u.customLayer,be=undefined===u.tickLabelOrientation?vt===steelseries.GaugeType.TYPE1?steelseries.TickLabelOrientation.TANGENT:steelseries.TickLabelOrientation.NORMAL:u.tickLabelOrientation,hu=undefined===u.trendVisible?!1:u.trendVisible,lr=undefined===u.trendColors?[steelseries.LedColor.RED_LED,steelseries.LedColor.GREEN_LED,steelseries.LedColor.CYAN_LED]:u.trendColors,ar=undefined===u.useOdometer?!1:u.useOdometer,si=undefined===u.odometerParams?{}:u.odometerParams,ke=undefined===u.odometerUseValue?!1:u.odometerUseValue,ef=undefined===u.fullScaleDeflectionTime?2.5:u.fullScaleDeflectionTime,e=ht(n);f===0&&(f=Math.min(e.canvas.width,e.canvas.height));e.canvas.width=f;e.canvas.height=f;rr&&ff!==!1&&(yi=d.createElement("audio"),yi.setAttribute("src",ff),yi.setAttribute("preload","auto"));var p=h,vr=h,of=this,pi=b,wi=h,ut=!1,yr=!1,sf=0,cu=0,bi,ki=!1,hf=steelseries.TrendState.OFF,pr=f*.06,wr=f*.29,br=f*.36,gi,yt,kr,pt,kt,lu=yt+(p-h)*kt,y=f,rt=f,st=y/2,lt=rt/2,ii=f*.093457,de=.6*y,ge=.4*rt,no=vt===steelseries.GaugeType.TYPE3?.6*y:st-ii/2,to=vt===steelseries.GaugeType.TYPE3?.72*rt:.75*rt,au=Math.floor(y/10),io=au+"px "+s,ro=au+"px "+wt,cf=rt*.13,ur=y*.4,lf=(y-ur)/2,af=rt*.57,vf,uo=rt*.61,yf=y*.006,pf=!1,dr=h,gr=b,fr=b-h,ri=gr-dr,nu=0,ui=0,nr=10,wf=10,fo=function(){ve?(fr=k(b-h,!1),ui=k(fr/(wf-1),!0),dr=Math.floor(h/ui)*ui,gr=Math.ceil(b/ui)*ui,nu=k(ui/(nr-1),!0),h=dr,b=gr,ri=b-h):(fr=b-h,dr=h,gr=b,ri=fr,ui=k(fr/(wf-1),!0),nu=k(ui/(nr-1),!0));switch(vt.type){case"type1":gi=0;yt=o;kr=i;pt=i;kt=pt/ri;break;case"type2":gi=0;yt=o;kr=i;pt=o;kt=pt/ri;break;case"type3":gi=0;yt=i;kr=0;pt=1.5*o;kt=pt/ri;break;case"type4":default:gi=60*c;yt=i+gi/2;kr=0;pt=t-gi;kt=pt/ri}lu=yt+(p-h)*kt},er=r(f,f),bf=er.getContext("2d"),or=r(f,f),at=or.getContext("2d"),kf,tr=r(ii,ii),df=tr.getContext("2d"),hi=r(ii,ii),gf=hi.getContext("2d"),ir=hi,ei=r(ii,ii),ne=ei.getContext("2d"),ni=r(ii,ii),te=ni.getContext("2d"),dt=ni,ie=r(Math.ceil(f*.028037),Math.ceil(f*.028037)),eo=ie.getContext("2d"),re=r(Math.ceil(f*.028037),Math.ceil(f*.028037)),oo=re.getContext("2d"),sr=r(f,f),ue=sr.getContext("2d"),hr=r(f,f),fe=hr.getContext("2d"),ee,oe,se,he,ce,tu,le;ar&&iu&&(tu=r(10,10),le=tu.getContext("2d"));var so=function(n,t){n.restore();n.save();n.textAlign="right";n.strokeStyle=di.textColor;n.fillStyle=di.textColor;(di===steelseries.LcdColor.STANDARD||di===steelseries.LcdColor.STANDARD_GREEN)&&(n.shadowColor="gray",n.shadowOffsetX=y*.007,n.shadowOffsetY=y*.007,n.shadowBlur=y*.007);n.font=pe?ro:io;n.fillText(t.toFixed(du),lf+ur-ur*.05,af+cf*.5+au*.38,ur*.9);n.restore()},ho=function(n){n.save();"type1"===vt.type&&n.drawImage(l(Math.ceil(rt*.037383),steelseries.KnobType.STANDARD_KNOB,vi),y*.523364,rt*.130841);("type1"===vt.type||"type2"===vt.type)&&n.drawImage(l(Math.ceil(rt*.037383),steelseries.KnobType.STANDARD_KNOB,vi),y*.130841,rt*.514018);("type2"===vt.type||"type3"===vt.type)&&n.drawImage(l(Math.ceil(rt*.037383),steelseries.KnobType.STANDARD_KNOB,vi),y*.831775,rt*.514018);"type3"===vt.type&&n.drawImage(l(Math.ceil(rt*.037383),steelseries.KnobType.STANDARD_KNOB,vi),y*.523364,rt*.831775);"type4"===vt.type&&(n.drawImage(l(Math.ceil(rt*.037383),steelseries.KnobType.STANDARD_KNOB,vi),y*.336448,rt*.803738),n.drawImage(l(Math.ceil(rt*.037383),steelseries.KnobType.STANDARD_KNOB,vi),y*.626168,rt*.803738));n.restore()},co=function(){var t=d.createElement("canvas"),n,i;return t.width=Math.ceil(f*.046728),t.height=Math.ceil(t.width*.9),n=t.getContext("2d"),n.save(),i=n.createLinearGradient(0,.1,0,t.height*.9),i.addColorStop(0,"#520000"),i.addColorStop(.3,"#fc1d00"),i.addColorStop(.59,"#fc1d00"),i.addColorStop(1,"#520000"),n.fillStyle=i,n.beginPath(),n.moveTo(t.width*.5,.1),n.lineTo(t.width*.9,t.height*.9),n.lineTo(t.width*.1,t.height*.9),n.lineTo(t.width*.5,.1),n.closePath(),n.fill(),n.strokeStyle="#FFFFFF",n.stroke(),n.restore(),t},ae=function(n,t,i,r,u){if(t<h?t=h:t>b&&(t=b),i<h?i=h:i>b&&(i=b),!(t>=i)){n.save();n.strokeStyle=r;n.fillStyle=r;n.lineWidth=y*.035;var f=pt/ri*t-pt/ri*h,e=f+(i-t)/(ri/pt);n.translate(st,lt);n.rotate(yt);n.beginPath();u?(n.moveTo(0,0),n.arc(0,0,y*.365-n.lineWidth/2,f,e,!1)):n.arc(0,0,y*.365,f,e,!1);u?(n.moveTo(0,0),n.fill()):n.stroke();n.translate(-st,-lt);n.restore()}},lo=function(n,t){var w=Math.ceil(y*.04),f=yt,r=kt*nu,u,e=h,c=nr-1,a=y*.38,k=y*.35,d=y*.355,g=y*.36,p=y*.3,l=y*.1,nt=nr/2,tt=parseFloat(b.toFixed(2)),v;for(ai.labelColor.setAlpha(1),n.save(),n.textAlign="center",n.textBaseline="middle",n.font=w+"px"+s,n.strokeStyle=ai.labelColor.getRgbaColor(),n.fillStyle=ai.labelColor.getRgbaColor(),n.translate(st,lt),n.rotate(yt),(vt.type==="type1"||vt.type==="type2")&&(l=y*.04),v=h;parseFloat(v.toFixed(2))<=tt;v+=nu){if(u=r+i,c++,c===nr){n.lineWidth=1.5;n.beginPath();n.moveTo(a,0);n.lineTo(k,0);n.closePath();n.stroke();n.save();n.translate(p,0);switch(be.type){case"horizontal":u=-f;break;case"tangent":u=f<=i+o?o:0;break;case"normal":default:u=i}n.rotate(u);switch(t.format){case"fractional":n.fillText(e.toFixed(gu),0,0,l);break;case"scientific":n.fillText(e.toPrecision(2),0,0,l);break;case"standard":default:n.fillText(e.toFixed(0),0,0,l)}n.translate(-p,0);n.restore();e+=ui;c=0;n.rotate(r);f+=r;continue}0==nr%2&&c===nt?(n.lineWidth=1,n.beginPath(),n.moveTo(a,0),n.lineTo(d,0),n.closePath(),n.stroke()):(n.lineWidth=.5,n.beginPath(),n.moveTo(a,0),n.lineTo(g,0),n.closePath(),n.stroke());n.rotate(r);f+=r}n.translate(-st,-lt);n.restore()},ot=function(n){var t,r,e;n=n||{};var o=undefined===n.frame?!1:n.frame,u=undefined===n.background?!1:n.background,s=undefined===n.led?!1:n.led,c=undefined===n.userLed?!1:n.userLed,l=undefined===n.pointer?!1:n.pointer,v=undefined===n.foreground?!1:n.foreground,b=undefined===n.trend?!1:n.trend,k=undefined===n.odo?!1:n.odo;if(pf=!0,fo(),o&&wu&&g(bf,pu,st,lt,y,rt),u&&bu&&(nt(at,ai,st,lt,y,rt),bt(at,we,st,lt,y,rt)),s&&(df.drawImage(a(Math.ceil(f*.093457),1,ru),0,0),gf.drawImage(a(Math.ceil(f*.093457),0,ru),0,0)),c&&(ne.drawImage(a(Math.ceil(f*.093457),1,fu),0,0),te.drawImage(a(Math.ceil(f*.093457),0,fu),0,0)),ou&&eo.drawImage(et(Math.ceil(f*.028037),steelseries.ColorDef.BLUE.dark.getRgbaColor(),!0,!0),0,0),su&&oo.drawImage(et(Math.ceil(f*.028037),steelseries.ColorDef.RED.medium.getRgbaColor(),!0),0,0),u&&bu){if(ho(at),null!==ci&&0<ci.length){t=ci.length;do t--,ae(at,ci[t].start,ci[t].stop,ci[t].color,!1);while(0<t)}if(null!==li&&0<li.length){r=li.length;do r--,ae(at,li[r].start,li[r].stop,li[r].color,!0);while(0<r)}lo(at,uf);fi(at,y,rt,vu,yu,ai,!0,!0)}u&&nf&&(at.save(),at.translate(st,lt),at.rotate(yt+(gt-h)*kt+i),at.translate(-st,-lt),at.drawImage(co(),y*.475,rt*.13),at.translate(st,lt),at.restore());u&&iu&&(ar&&k?(ce=new steelseries.Odometer("",{_context:le,height:f*.075,decimals:si.decimals,digits:si.digits===undefined?5:si.digits,valueForeColor:si.valueForeColor,valueBackColor:si.valueBackColor,decimalForeColor:si.decimalForeColor,decimalBackColor:si.decimalBackColor,font:si.font,value:p}),vf=(y-tu.width)/2):ar||(kf=it(ur,cf,di),at.drawImage(kf,lf,af)));l&&ft(ue,y,oi,ku,ai.labelColor);v&&rf&&(e=oi.type==="type15"||oi.type==="type16"?!1:!0,tt(fe,tf,y,rt,e,ye,vi,vt));b&&hu&&(ee=w(pr,steelseries.TrendState.UP,lr),oe=w(pr,steelseries.TrendState.STEADY,lr),se=w(pr,steelseries.TrendState.DOWN,lr),he=w(pr,steelseries.TrendState.OFF,lr))},ct=function(n){n=n||{};var t=undefined===n.frame?!1:n.frame,i=undefined===n.background?!1:n.background,r=undefined===n.led?!1:n.led,u=undefined===n.userLed?!1:n.userLed,e=undefined===n.pointer?!1:n.pointer,o=undefined===n.foreground?!1:n.foreground;t&&(er.width=f,er.height=f,bf=er.getContext("2d"));i&&(or.width=f,or.height=f,at=or.getContext("2d"));r&&(tr.width=Math.ceil(f*.093457),tr.height=Math.ceil(f*.093457),df=tr.getContext("2d"),hi.width=Math.ceil(f*.093457),hi.height=Math.ceil(f*.093457),gf=hi.getContext("2d"),ir=hi);u&&(ei.width=Math.ceil(f*.093457),ei.height=Math.ceil(f*.093457),ne=ei.getContext("2d"),ni.width=Math.ceil(f*.093457),ni.height=Math.ceil(f*.093457),te=ni.getContext("2d"),dt=ni);e&&(sr.width=f,sr.height=f,ue=sr.getContext("2d"));o&&(hr.width=f,hr.height=f,fe=hr.getContext("2d"))},ao=function(){uu&&(ir=ir===tr?hi:tr,ki||(ki=!0,v(of.repaint)))},vo=function(){eu&&(dt=dt===ei?ni:ei,ki||(ki=!0,v(of.repaint)))},cr=function(n){n?sf=setInterval(ao,1e3):(clearInterval(sf),ir=hi)},yo=function(n){n?cu=setInterval(vo,1e3):(clearInterval(cu),dt=ni)};return this.setValue=function(n){n=parseFloat(n);var t=n<h?h:n>b?b:n;return p!==t&&(p=t,p>wi&&(wi=p),p<pi&&(pi=p),p>=gt&&!ut&&ti||p<=gt&&!ut&&!ti?(ut=!0,cr(ut),rr&&yi.play()):(p<gt&&ut&&ti||p>gt&&ut&&!ti)&&(ut=!1,cr(ut),rr&&yi.pause()),this.repaint()),this},this.getValue=function(){return p},this.setOdoValue=function(n){n=parseFloat(n);var t=n<0?0:n;return vr!==t&&(vr=t,this.repaint()),this},this.getOdoValue=function(){return vr},this.setValueAnimated=function(n,t){n=parseFloat(n);var r=n<h?h:n>b?b:n,u=this,i;return p!==r&&(undefined!==bi&&bi.isPlaying&&bi.stop(),i=ef*Math.abs(r-p)/(b-h),i=Math.max(i,ef/5),bi=new Tween({},"",Tween.regularEaseInOut,p,r,i),bi.onMotionChanged=function(n){p=n.target._pos;p>=gt&&!ut&&ti||p<=gt&&!ut&&!ti?(ut=!0,cr(ut),rr&&yi.play()):(p<gt&&ut&&ti||p>gt&&ut&&!ti)&&(ut=!1,cr(ut),rr&&yi.pause());p>wi&&(wi=p);p<pi&&(pi=p);ki||(ki=!0,v(u.repaint))},t&&typeof t=="function"&&(bi.onMotionFinished=t),bi.start()),this},this.resetMinMeasuredValue=function(){pi=p;this.repaint()},this.resetMaxMeasuredValue=function(){return wi=p,this.repaint(),this},this.setMinMeasuredValueVisible=function(n){return ou=!!n,this.repaint(),this},this.setMaxMeasuredValueVisible=function(n){return su=!!n,this.repaint(),this},this.setMaxMeasuredValue=function(n){n=parseFloat(n);var t=n<h?h:n>b?b:n;return wi=t,this.repaint(),this},this.setMinMeasuredValue=function(n){n=parseFloat(n);var t=n<h?h:n>b?b:n;return pi=t,this.repaint(),this},this.setTitleString=function(n){return vu=n,ct({background:!0}),ot({background:!0}),this.repaint(),this},this.setUnitString=function(n){return yu=n,ct({background:!0}),ot({background:!0}),this.repaint(),this},this.setMinValue=function(n){return h=parseFloat(n),ct({frame:!0,background:!0}),ot({frame:!0,background:!0}),this.repaint(),this},this.getMinValue=function(){return h},this.setMaxValue=function(n){return b=parseFloat(n),ct({frame:!0,background:!0}),ot({frame:!0,background:!0}),this.repaint(),this},this.getMaxValue=function(){return b},this.setThreshold=function(n){n=parseFloat(n);var t=n<h?h:n>b?b:n;return gt=t,ct({background:!0}),ot({background:!0}),this.repaint(),this},this.setArea=function(n){return li=n,ct({background:!0,foreground:!0}),ot({background:!0,foreground:!0}),this.repaint(),this},this.setSection=function(n){return ci=n,ct({background:!0,foreground:!0}),ot({background:!0,foreground:!0}),this.repaint(),this},this.setThresholdVisible=function(n){return nf=!!n,this.repaint(),this},this.setThresholdRising=function(n){return ti=!!n,ut=!ut,cr(ut),this.repaint(),this},this.setLcdDecimals=function(n){return du=parseInt(n,10),this.repaint(),this},this.setFrameDesign=function(n){return ct({frame:!0}),pu=n,ot({frame:!0}),this.repaint(),this},this.setBackgroundColor=function(n){return ct({background:!0,pointer:oi.type==="type2"||oi.type==="type13"?!0:!1}),ai=n,ot({background:!0,pointer:oi.type==="type2"||oi.type==="type13"?!0:!1}),this.repaint(),this},this.setForegroundType=function(n){return ct({foreground:!0}),tf=n,ot({foreground:!0}),this.repaint(),this},this.setPointerType=function(n){return ct({pointer:!0,foreground:!0}),oi=n,ot({pointer:!0,foreground:!0}),this.repaint(),this},this.setPointerColor=function(n){return ct({pointer:!0}),ku=n,ot({pointer:!0}),this.repaint(),this},this.setLedColor=function(n){return ct({led:!0}),ru=n,ot({led:!0}),this.repaint(),this},this.setUserLedColor=function(n){return ct({userLed:!0}),fu=n,ot({userLed:!0}),this.repaint(),this},this.toggleUserLed=function(){return dt=dt===ei?ni:ei,this.repaint(),this},this.setUserLedOnOff=function(n){return dt=!0===n?ei:ni,this.repaint(),this},this.blinkUserLed=function(n){return n?yr||(yo(!0),yr=!0):yr&&(clearInterval(cu),yr=!1),this},this.setLedVisible=function(n){return uu=!!n,this.repaint(),this},this.setUserLedVisible=function(n){return eu=!!n,this.repaint(),this},this.setLcdColor=function(n){return di=n,ct({background:!0}),ot({background:!0}),this.repaint(),this},this.setTrend=function(n){return hf=n,this.repaint(),this},this.setTrendVisible=function(n){return hu=!!n,this.repaint(),this},this.setFractionalScaleDecimals=function(n){return gu=parseInt(n,10),ct({background:!0}),ot({background:!0}),this.repaint(),this},this.setLabelNumberFormat=function(n){return uf=n,ct({background:!0}),ot({background:!0}),this.repaint(),this},this.repaint=function(){if(pf||ot({frame:!0,background:!0,led:!0,userLed:!0,pointer:!0,trend:!0,foreground:!0,odo:!0}),e.clearRect(0,0,f,f),wu&&e.drawImage(er,0,0),e.drawImage(or,0,0),iu&&(ar?(ce.setValue(ke?p:vr),e.drawImage(tu,vf,uo)):so(e,p)),uu&&e.drawImage(ir,de,ge),eu&&e.drawImage(dt,no,to),hu)switch(hf.state){case"up":e.drawImage(ee,wr,br);break;case"steady":e.drawImage(oe,wr,br);break;case"down":e.drawImage(se,wr,br);break;case"off":e.drawImage(he,wr,br)}ou&&(e.save(),e.translate(st,lt),e.rotate(yt+i+(pi-h)*kt),e.translate(-st,-lt),e.drawImage(ie,e.canvas.width*.4865,e.canvas.height*.105),e.restore());su&&(e.save(),e.translate(st,lt),e.rotate(yt+i+(wi-h)*kt),e.translate(-st,-lt),e.drawImage(re,e.canvas.width*.4865,e.canvas.height*.105),e.restore());lu=yt+i+(p-h)*kt;e.save();e.translate(st,lt);e.rotate(lu);e.translate(-st,-lt);e.shadowColor="rgba(0, 0, 0, 0.8)";e.shadowOffsetX=e.shadowOffsetY=yf;e.shadowBlur=yf*2;e.drawImage(sr,0,0);e.restore();rf&&e.drawImage(hr,0,0);ki=!1},this.repaint(),this},ci=function(n,u){var li;u=u||{};var hi=undefined===u.gaugeType?steelseries.GaugeType.TYPE4:u.gaugeType,h=undefined===u.size?0:u.size,f=undefined===u.minValue?0:u.minValue,l=undefined===u.maxValue?f+100:u.maxValue,re=undefined===u.niceScale?!0:u.niceScale,gt=undefined===u.threshold?(l-f)/2+f:u.threshold,ni=undefined===u.thresholdRising?!0:u.thresholdRising,ci=undefined===u.section?null:u.section,su=undefined===u.useSectionColors?!1:u.useSectionColors,hu=undefined===u.titleString?"":u.titleString,cu=undefined===u.unitString?"":u.unitString,lu=undefined===u.frameDesign?steelseries.FrameDesign.METAL:u.frameDesign,au=undefined===u.frameVisible?!0:u.frameVisible,yi=undefined===u.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:u.backgroundColor,vu=undefined===u.backgroundVisible?!0:u.backgroundVisible,sr=undefined===u.valueColor?steelseries.ColorDef.RED:u.valueColor,pi=undefined===u.lcdColor?steelseries.LcdColor.STANDARD:u.lcdColor,yu=undefined===u.lcdVisible?!0:u.lcdVisible,pu=undefined===u.lcdDecimals?2:u.lcdDecimals,ue=undefined===u.digitalFont?!1:u.digitalFont,wu=undefined===u.fractionalScaleDecimals?1:u.fractionalScaleDecimals,fe=undefined===u.customLayer?null:u.customLayer,dr=undefined===u.ledColor?steelseries.LedColor.RED_LED:u.ledColor,gr=undefined===u.ledVisible?!0:u.ledVisible,nu=undefined===u.userLedColor?steelseries.LedColor.GREEN_LED:u.userLedColor,tu=undefined===u.userLedVisible?!1:u.userLedVisible,bu=undefined===u.labelNumberFormat?steelseries.LabelNumberFormat.STANDARD:u.labelNumberFormat,ku=undefined===u.foregroundType?steelseries.ForegroundType.TYPE1:u.foregroundType,du=undefined===u.foregroundVisible?!0:u.foregroundVisible,gi=undefined===u.playAlarm?!1:u.playAlarm,gu=undefined===u.alarmSound?!1:u.alarmSound,nr=undefined===u.valueGradient?null:u.valueGradient,nf=undefined===u.useValueGradient?!1:u.useValueGradient,ee=undefined===u.tickLabelOrientation?hi===steelseries.GaugeType.TYPE1?steelseries.TickLabelOrientation.TANGENT:steelseries.TickLabelOrientation.NORMAL:u.tickLabelOrientation,iu=undefined===u.trendVisible?!1:u.trendVisible,hr=undefined===u.trendColors?[steelseries.LedColor.RED_LED,steelseries.LedColor.GREEN_LED,steelseries.LedColor.CYAN_LED]:u.trendColors,tf=undefined===u.fullScaleDeflectionTime?2.5:u.fullScaleDeflectionTime,p=ht(n);h===0&&(h=Math.min(p.canvas.width,p.canvas.height));p.canvas.width=h;p.canvas.height=h;gi&&gu!==!1&&(li=d.createElement("audio"),li.setAttribute("src",gu),li.setAttribute("preload","auto"));var ft=f,vt=l-f,rt=!1,rf=0,cr=!1,ru=0,ai,uf=this,vi=!1,at,ot,wi,ui,b,ti,kt,oe,bi=[],lr=!1,uu=!1,e=h,st=h,et=e/2,ct=st/2,fu=Math.floor(e/10),se=fu+"px "+s,he=fu+"px "+wt,eu=st*.13,tr=e*.4,ff=(e-tr)/2,ef=st/2-eu/2,ce=e*.116822,le=e*.485981,y=Math.ceil(h*.093457),of=e*.53,sf=st*.61,ae=hi===steelseries.GaugeType.TYPE3?.7*e:et-y/2,ve=hi===steelseries.GaugeType.TYPE3?.61*st:.75*st,hf=steelseries.TrendState.OFF,ar=h*.06,vr=h*.38,yr=h*.57;switch(hi.type){case"type1":at=0;ot=o;wi=0;ui=i;b=i;ti=b*pt;kt=b/vt;break;case"type2":at=0;ot=o;wi=0;ui=i;b=o;ti=b*pt;kt=b/vt;break;case"type3":at=0;ot=i;wi=-i;ui=0;b=1.5*o;ti=b*pt;kt=b/vt;break;case"type4":default:at=60*c;ot=i+at/2;wi=-t/6;ui=0;b=t-at;ti=b*pt;kt=b/vt}var ir=r(h,h),cf=ir.getContext("2d"),rr=r(h,h),oi=rr.getContext("2d"),lf,ur=r(Math.ceil(h*.060747),Math.ceil(h*.023364)),ou=ur.getContext("2d"),ki=r(y,y),af=ki.getContext("2d"),si=r(y,y),vf=si.getContext("2d"),di=si,ii=r(y,y),yf=ii.getContext("2d"),dt=r(y,y),pf=dt.getContext("2d"),yt=dt,ye,fr=r(h,h),wf=fr.getContext("2d"),bf,kf,df,gf,ne=!1,pr=f,wr=l,er=l-f;vt=wr-pr;var br=0,ri=0,kr=10,te=10,pe=function(){re?(er=k(l-f,!1),ri=k(er/(te-1),!0),pr=Math.floor(f/ri)*ri,wr=Math.ceil(l/ri)*ri,br=k(ri/(kr-1),!0),f=pr,l=wr,vt=l-f):(er=l-f,pr=f,wr=l,vt=er,ri=k(er/(te-1),!0),br=k(ri/(kr-1),!0));switch(hi.type){case"type1":at=0;ot=o;ui=i;b=i;kt=b/vt;break;case"type2":at=0;ot=o;ui=i;b=o;kt=b/vt;break;case"type3":at=0;ot=i;ui=0;b=1.5*o;kt=b/vt;break;case"type4":default:at=60*c;ot=i+at/2;ui=0;b=t-at;kt=b/vt}oe=ot+(ft-f)*kt},ut=function(n){var t;n=n||{};var r=undefined===n.frame?!1:n.frame,i=undefined===n.background?!1:n.background,u=undefined===n.led?!1:n.led,o=undefined===n.userLed?!1:n.userLed,s=undefined===n.value?!1:n.value,h=undefined===n.foreground?!1:n.foreground,c=undefined===n.trend?!1:n.trend;if(ne=!0,pe(),r&&au&&g(cf,lu,et,ct,e,st),i&&vu&&(nt(oi,yi,et,ct,e,st),bt(oi,fe,et,ct,e,st)),u&&(af.drawImage(a(y,1,dr),0,0),vf.drawImage(a(y,0,dr),0,0),ye=oi.getImageData(of,sf,y,y)),o&&(yf.drawImage(a(Math.ceil(y),1,nu),0,0),pf.drawImage(a(Math.ceil(y),0,nu),0,0)),i&&we(oi),i&&vu&&(ke(oi,bu),fi(oi,e,st,hu,cu,yi,!0,!0)),i&&yu&&(lf=it(tr,eu,pi),oi.drawImage(lf,ff,ef)),lr=!1,su&&null!==ci&&0<ci.length){lr=!0;t=ci.length;bi=[];do t--,bi.push({start:(ci[t].start+Math.abs(f))/(l-f)*ti,stop:(ci[t].stop+Math.abs(f))/(l-f)*ti,color:ei(ci[t].color)});while(0<t)}uu=!1;nf&&nr!==null&&(lr=!1,uu=!0);s&&ie(ou,sr);h&&du&&tt(wf,ku,e,st,!1);c&&iu&&(bf=w(ar,steelseries.TrendState.UP,hr),kf=w(ar,steelseries.TrendState.STEADY,hr),df=w(ar,steelseries.TrendState.DOWN,hr),gf=w(ar,steelseries.TrendState.OFF,hr))},lt=function(n){n=n||{};var t=undefined===n.frame?!1:n.frame,i=undefined===n.background?!1:n.background,r=undefined===n.led?!1:n.led,u=undefined===n.userLed?!1:n.userLed,f=undefined===n.value?!1:n.value,e=undefined===n.foreground?!1:n.foreground;t&&(ir.width=h,ir.height=h,cf=ir.getContext("2d"));i&&(rr.width=h,rr.height=h,oi=rr.getContext("2d"));f&&(ur.width=Math.ceil(h*.060747),ur.height=Math.ceil(h*.023364),ou=ur.getContext("2d"));r&&(ki.width=Math.ceil(y),ki.height=Math.ceil(y),af=ki.getContext("2d"),si.width=Math.ceil(y),si.height=Math.ceil(y),vf=si.getContext("2d"),di=si);u&&(ii.width=Math.ceil(y),ii.height=Math.ceil(y),yf=ii.getContext("2d"),dt.width=Math.ceil(y),dt.height=Math.ceil(y),pf=dt.getContext("2d"),yt=dt);e&&(fr.width=h,fr.height=h,wf=fr.getContext("2d"))},we=function(n){var t,r,i;n.save();n.save();n.lineWidth=h*.085;n.beginPath();n.translate(et,ct);n.rotate(ot-4*c);n.translate(-et,-ct);n.arc(et,ct,e*.35514,0,b+8*c,!1);n.rotate(-ot);t=n.createLinearGradient(0,.107476*st,0,.897195*st);t.addColorStop(0,"#000000");t.addColorStop(.22,"#333333");t.addColorStop(.76,"#333333");t.addColorStop(1,"#cccccc");n.strokeStyle=t;n.stroke();n.restore();n.save();n.lineWidth=h*.075;n.beginPath();n.translate(et,ct);n.rotate(ot-4*c);n.translate(-et,-ct);n.arc(et,ct,e*.35514,0,b+8*c,!1);n.rotate(-ot);r=n.createLinearGradient(0,.112149*st,0,.892523*st);r.addColorStop(0,"#111111");r.addColorStop(1,"#333333");n.strokeStyle=r;n.stroke();n.restore();var f=(e*.116822+e*.060747)/2,o=(e*.485981+e*.023364)/2,u=n.createRadialGradient(f,o,0,f,o,.030373*e);for(u.addColorStop(0,"#3c3c3c"),u.addColorStop(1,"#323232"),i=0,i=0;i<=ti;i+=5)n.save(),n.translate(et,ct),n.rotate(i*c+wi),n.translate(-et,-ct),n.beginPath(),n.rect(e*.116822,e*.485981,e*.060747,e*.023364),n.closePath(),n.fillStyle=u,n.fill(),n.restore();n.restore()},ie=function(n,t){n.save();n.beginPath();n.rect(0,0,n.canvas.width,n.canvas.height);n.closePath();var r=n.canvas.width/2,u=n.canvas.height/2,i=p.createRadialGradient(r,u,0,r,u,n.canvas.width/2);i.addColorStop(0,t.light.getRgbaColor());i.addColorStop(1,t.dark.getRgbaColor());n.fillStyle=i;n.fill();n.restore()},be=function(n,t){n.save();n.textAlign="right";n.strokeStyle=pi.textColor;n.fillStyle=pi.textColor;(pi===steelseries.LcdColor.STANDARD||pi===steelseries.LcdColor.STANDARD_GREEN)&&(n.shadowColor="gray",n.shadowOffsetX=e*.007,n.shadowOffsetY=e*.007,n.shadowBlur=e*.007);n.font=ue?he:se;n.fillText(t.toFixed(pu),ff+tr-tr*.05,ef+eu*.5+fu*.38,tr*.9);n.restore()},ke=function(n,t){var h=ot,r=kt*br,u,w=Math.ceil(e*.04),c=f,v=kr-1,p=e*.28,a=e*.1,b=parseFloat(l.toFixed(2)),y;for(yi.labelColor.setAlpha(1),n.save(),n.textAlign="center",n.textBaseline="middle",n.font=w+"px "+s,n.strokeStyle=yi.labelColor.getRgbaColor(),n.fillStyle=yi.labelColor.getRgbaColor(),n.translate(et,ct),n.rotate(ot),(hi.type==="type1"||hi.type==="type2")&&(a=e*.0375),y=f;parseFloat(y.toFixed(2))<=b;y+=br){if(u=+r+i,v++,v===kr){n.save();n.translate(p,0);switch(ee.type){case"horizontal":u=-h;break;case"tangent":u=h<=i+o?o:0;break;case"normal":default:u=i}n.rotate(u);switch(t.format){case"fractional":n.fillText(c.toFixed(wu),0,0,a);break;case"scientific":n.fillText(c.toPrecision(2),0,0,a);break;case"standard":default:n.fillText(c.toFixed(0),0,0,a)}n.translate(-p,0);n.restore();c+=ri;v=0;n.rotate(r);h+=r;continue}n.rotate(r);h+=r}n.translate(-et,-ct);n.restore()},or=function(n){n?rf=setInterval(ge,1e3):(clearInterval(rf),di=si)},de=function(n){n?ru=setInterval(no,1e3):(clearInterval(ru),yt=dt)},ge=function(){gr&&(di=di===ki?si:ki,vi||(vi=!0,v(uf.repaint)))},no=function(){tu&&(yt=yt===ii?dt:ii,vi||(vi=!0,v(uf.repaint)))};return this.setValue=function(n){n=parseFloat(n);var t=n<f?f:n>l?l:n;return ft!==t&&(ft=t,ft>=gt&&!rt&&ni||ft<=gt&&!rt&&!ni?(rt=!0,or(rt),gi&&li.play()):(ft<gt&&rt&&ni||ft>gt&&rt&&!ni)&&(rt=!1,or(rt),gi&&li.pause()),this.repaint()),this},this.getValue=function(){return ft},this.setValueAnimated=function(n,t){n=parseFloat(n);var r=n<f?f:n>l?l:n,u=this,i;return ft!==r&&(undefined!==ai&&ai.isPlaying&&ai.stop(),i=tf*Math.abs(r-ft)/(l-f),i=Math.max(i,tf/5),ai=new Tween({},"",Tween.regularEaseInOut,ft,r,i),ai.onMotionChanged=function(n){ft=n.target._pos;ft>=gt&&!rt&&ni||ft<=gt&&!rt&&!ni?(rt=!0,or(rt),gi&&li.play()):(ft<gt&&rt&&ni||ft>gt&&rt&&!ni)&&(rt=!1,or(rt),gi&&li.pause());vi||(vi=!0,v(u.repaint))},t&&typeof t=="function"&&(ai.onMotionFinished=t),ai.start()),this},this.setFrameDesign=function(n){return lt({frame:!0}),lu=n,ut({frame:!0}),this.repaint(),this},this.setBackgroundColor=function(n){return lt({background:!0,led:!0}),yi=n,ut({background:!0,led:!0}),this.repaint(),this},this.setForegroundType=function(n){return lt({foreground:!0}),ku=n,ut({foreground:!0}),this.repaint(),this},this.setValueColor=function(n){return lt({value:!0}),sr=n,ut({value:!0}),this.repaint(),this},this.setLedColor=function(n){return lt({led:!0}),dr=n,ut({led:!0}),this.repaint(),this},this.setUserLedColor=function(n){return lt({userLed:!0}),nu=n,ut({userLed:!0}),this.repaint(),this},this.toggleUserLed=function(){return yt=yt===ii?dt:ii,this.repaint(),this},this.setUserLedOnOff=function(n){return yt=!0===n?ii:dt,this.repaint(),this},this.blinkUserLed=function(n){return n?cr||(de(!0),cr=!0):cr&&(clearInterval(ru),cr=!1),this},this.setLedVisible=function(n){return gr=!!n,this.repaint(),this},this.setUserLedVisible=function(n){return tu=!!n,this.repaint(),this},this.setLcdColor=function(n){return pi=n,lt({background:!0}),ut({background:!0}),this.repaint(),this},this.setLcdDecimals=function(n){return pu=parseInt(n,10),this.repaint(),this},this.setSection=function(n){return ci=n,ut(),this.repaint(),this},this.setSectionActive=function(n){return su=n,ut(),this.repaint(),this},this.setGradient=function(n){return nr=n,ut(),this.repaint(),this},this.setGradientActive=function(n){return nf=n,ut(),this.repaint(),this},this.setMinValue=function(n){return f=n,lt({background:!0}),ut({background:!0}),this.repaint(),this},this.getMinValue=function(){return f},this.setMaxValue=function(n){return l=n,lt({background:!0}),ut({background:!0}),this.repaint(),this},this.getMaxValue=function(){return l},this.setThreshold=function(n){n=parseFloat(n);var t=n<f?f:n>l?l:n;return gt=t,lt({background:!0}),ut({background:!0}),this.repaint(),this},this.setThresholdRising=function(n){return ni=!!n,rt=!rt,or(rt),this.repaint(),this},this.setTitleString=function(n){return hu=n,lt({background:!0}),ut({background:!0}),this.repaint(),this},this.setUnitString=function(n){return cu=n,lt({background:!0}),ut({background:!0}),this.repaint(),this},this.setTrend=function(n){return hf=n,this.repaint(),this},this.setTrendVisible=function(n){return iu=!!n,this.repaint(),this},this.setFractionalScaleDecimals=function(n){wu=parseInt(n,10);lt({background:!0});ut({background:!0});this.repaint()},this.setLabelNumberFormat=function(n){return bu=n,lt({background:!0}),ut({background:!0}),this.repaint(),this},this.repaint=function(){var s=(ft-f)/(l-f)*ti,t,u=sr,n,i,e,o,r;for(ne||ut({frame:!0,background:!0,led:!0,userLed:!0,value:!0,trend:!0,foreground:!0}),p.clearRect(0,0,h,h),au&&p.drawImage(ir,0,0),p.drawImage(rr,0,0),n=0;n<=s;n+=5){if(t=sr,uu)e=f+n/ti*(l-f),o=nr.getEnd()-nr.getStart(),r=(e-f)/o,r=Math.max(Math.min(r,1),0),t=ei(nr.getColorAt(r).getRgbaColor());else if(lr)for(i=0;i<bi.length;i++)if(n>=bi[i].start&&n<bi[i].stop){t=bi[i].color;break}u.medium.getHexColor()!==t.medium.getHexColor()&&(ie(ou,t),u=t);p.save();p.translate(et,ct);p.rotate(n*c+wi);p.translate(-et,-ct);p.drawImage(ur,ce,le);p.restore()}if(yu&&be(p,ft),gr&&p.drawImage(di,of,sf),tu&&p.drawImage(yt,ae,ve),iu)switch(hf.state){case"up":p.drawImage(bf,vr,yr);break;case"steady":p.drawImage(kf,vr,yr);break;case"down":p.drawImage(df,vr,yr);break;case"off":p.drawImage(gf,vr,yr)}du&&p.drawImage(fr,0,0);vi=!1},this.repaint(),this},li=function(n,t){t=t||{};var l=undefined===t.width?0:t.width,a=undefined===t.height?0:t.height,y=undefined===t.lcdColor?steelseries.LcdColor.STANDARD:t.lcdColor,bt=undefined===t.lcdDecimals?2:t.lcdDecimals,nt=undefined===t.unitString?"":t.unitString,tt=undefined===t.unitStringVisible?!1:t.unitStringVisible,kt=undefined===t.headerString?"":t.headerString,ut=undefined===t.headerStringVisible?!1:t.headerStringVisible,ft=undefined===t.digitalFont?!1:t.digitalFont,gt=undefined===t.valuesNumeric?!0:t.valuesNumeric,p=undefined===t.value?0:t.value,ni=undefined===t.alwaysScroll?!1:t.alwaysScroll,et=undefined===t.autoScroll?!1:t.autoScroll,u=undefined===t.section?null:t.section,c=!1,o=0,b,k=!1,ti=this,i=ht(n);l===0&&(l=i.canvas.width);a===0&&(a=i.canvas.height);i.canvas.width=l;i.canvas.height=a;var e=l,f=a,h=0,w=Math.floor(f/1.5),ct=w+"px "+s,lt=w+"px "+wt,at=!1,vt,yt=[],pt=[],ii=function(n,t){var l,a,r;i.save();i.textAlign="right";i.strokeStyle=t;i.fillStyle=t;i.beginPath();i.rect(2,0,e-4,f);i.closePath();i.clip();(y===steelseries.LcdColor.STANDARD||y===steelseries.LcdColor.STANDARD_GREEN)&&u===null&&(i.shadowColor="gray",i.shadowOffsetX=f*.035,i.shadowOffsetY=f*.035,i.shadowBlur=f*.055);i.font=ft?lt:ct;gt?(l=0,h=0,tt&&(i.font=Math.floor(f/2.5)+"px "+s,l=i.measureText(nt).width),i.font=ft?lt:ct,a=n.toFixed(bt),h=i.measureText(a).width,r=.38,ut&&(r=.52),i.fillText(a,e-l-4-o,f*.5+w*r),tt&&(i.font=Math.floor(f/2.5)+"px "+s,i.fillText(nt,e-2-o,f*.5+w*r)),ut&&(i.textAlign="center",i.font=Math.floor(f/3.5)+"px "+s,i.fillText(kt,e/2,f*.3))):(h=i.measureText(n).width,ni||et&&h>e-4?c||(o=h>e*.8?e-h-e*.2:0,c=!0,clearTimeout(b),b=setTimeout(d,200)):et&&h<=e-4&&(o=0,c=!1),i.fillText(n,e-2-o,f*.5+w*.38));i.restore()},ri=function(n,t,i,u){var tt=r(n,t),f=tt.getContext("2d");f.save();var h=0,et=n,it=t,ut=Math.min(n,t)*.095,s=f.createLinearGradient(0,h,0,h+it);s.addColorStop(0,"#4c4c4c");s.addColorStop(.08,"#666666");s.addColorStop(.92,"#666666");s.addColorStop(1,"#e6e6e6");f.fillStyle=s;dt(f,0,h,et,it,ut);f.fill();f.restore();f.save();var c=rt(i),e=ot(c[0],c[1],c[2]),l=rt(u.gradientStartColor),ht=ot(l[0],l[1],l[2]),a=rt(u.gradientFraction1Color),ct=ot(a[0],a[1],a[2]),v=rt(u.gradientFraction2Color),lt=ot(v[0],v[1],v[2]),y=rt(u.gradientFraction3Color),at=ot(y[0],y[1],y[2]),p=rt(u.gradientStopColor),vt=ot(p[0],p[1],p[2]),w=st(e[0],e[1],ht[2]-.31),b=st(e[0],e[1],ct[2]-.31),k=st(e[0],e[1],lt[2]-.31),d=st(e[0],e[1],at[2]-.31),g=st(e[0],e[1],vt[2]-.31),nt=1,yt=n-2,ft=t-2,pt=ut-1,o=f.createLinearGradient(0,nt,0,nt+ft);return o.addColorStop(0,"rgb("+w[0]+", "+w[1]+", "+w[2]+")"),o.addColorStop(.03,"rgb("+b[0]+","+b[1]+","+b[2]+")"),o.addColorStop(.49,"rgb("+k[0]+","+k[1]+","+k[2]+")"),o.addColorStop(.5,"rgb("+d[0]+","+d[1]+","+d[2]+")"),o.addColorStop(1,"rgb("+g[0]+","+g[1]+","+g[2]+")"),f.fillStyle=o,dt(f,1,nt,yt,ft,pt),f.fill(),f.restore(),tt},ui=function(n){var t=rt(n),r=ot(t[0],t[1],t[2]),i=st(r[0],.57,.83);return"rgb("+i[0]+", "+i[1]+", "+i[2]+")"},d=function(){c?(o>e&&(o=-h),o+=2,b=setTimeout(d,50)):o=0;k||(k=!0,v(ti.repaint))},g=function(){var n;if(at=!0,vt=it(l,a,y),null!==u&&0<u.length)for(n=0;n<u.length;n++)yt[n]=ri(l,a,u[n].color,y),pt[n]=ui(u[n].color)};return this.setValue=function(n){return p!==n&&(p=n,this.repaint()),this},this.setLcdColor=function(n){return y=n,g(),this.repaint(),this},this.setSection=function(n){return u=n,g({background:!0,foreground:!0}),this.repaint(),this},this.setScrolling=function(n){if(n){if(c)return;c=n;d()}else c=n;return this},this.repaint=function(){at||g();i.clearRect(0,0,i.canvas.width,i.canvas.height);var t=vt,r=y.textColor,n;if(null!==u&&0<u.length)for(n=0;n<u.length;n++)if(p>=u[n].start&&p<=u[n].stop){t=yt[n];r=pt[n];break}i.drawImage(t,0,0);ii(p,r);k=!1},this.repaint(),this},ai=function(n,u){u=u||{};var o=undefined===u.size?0:u.size,hi=undefined===u.frameDesign?steelseries.FrameDesign.METAL:u.frameDesign,ci=undefined===u.frameVisible?!0:u.frameVisible,rt=undefined===u.backgroundColor?steelseries.BackgroundColor.DARK_GRAY:u.backgroundColor,li=undefined===u.backgroundVisible?!0:u.backgroundVisible,dt=undefined===u.pointerTypeLatest?steelseries.PointerType.TYPE1:u.pointerTypeLatest,ai=undefined===u.pointerTypeAverage?steelseries.PointerType.TYPE8:u.pointerTypeAverage,ii=undefined===u.pointerColor?steelseries.ColorDef.RED:u.pointerColor,ri=undefined===u.pointerColorAverage?steelseries.ColorDef.BLUE:u.pointerColorAverage,ar=undefined===u.knobType?steelseries.KnobType.STANDARD_KNOB:u.knobType,vr=undefined===u.knobStyle?steelseries.KnobStyle.SILVER:u.knobStyle,vi=undefined===u.foregroundType?steelseries.ForegroundType.TYPE1:u.foregroundType,yi=undefined===u.foregroundVisible?!0:u.foregroundVisible,h=undefined===u.pointSymbols?["N","NE","E","SE","S","SW","W","NW"]:u.pointSymbols,yr=undefined===u.pointSymbolsVisible?!0:u.pointSymbolsVisible,pr=undefined===u.customLayer?null:u.customLayer,wr=undefined===u.degreeScale?!0:u.degreeScale,ui=undefined===u.degreeScaleHalf?!1:u.degreeScaleHalf,wi=undefined===u.roseVisible?!1:u.roseVisible,lt=undefined===u.lcdColor?steelseries.LcdColor.STANDARD:u.lcdColor,bi=undefined===u.lcdVisible?!0:u.lcdVisible,br=undefined===u.digitalFont?!1:u.digitalFont,et=undefined===u.section?null:u.section,ot=undefined===u.area?null:u.area,gt=undefined===u.lcdTitleStrings?["Latest","Average"]:u.lcdTitleStrings,ki=undefined===u.titleString?"":u.titleString,di=undefined===u.useColorLabels?!1:u.useColorLabels,ni=undefined===u.fullScaleDeflectionTime?2.5:u.fullScaleDeflectionTime,st,ct,y=0,p=0,at=c,gi=this.valueLatest,fi=this.valueAverage,kr=-i,nr=t,tr=360,l=!1,e=ht(n);o===0&&(o=Math.min(e.canvas.width,e.canvas.height));e.canvas.width=o;e.canvas.height=o;var f=o,w=o,b=f/2,k=w/2,ei=Math.floor(f/10),dr=ei+"px "+s,gr=ei+"px "+wt,ti=f*.3,ir=w*.12,rr=(f-ti)/2,ur=w*.32,fr=w*.565,er=!1,vt=r(o,o),ut=vt.getContext("2d"),oi,yt=r(o,o),or=yt.getContext("2d"),pt=r(o,o),sr=pt.getContext("2d"),kt=r(o,o),hr=kt.getContext("2d"),cr=function(n,t){for(e.save(),e.textAlign="center",e.strokeStyle=lt.textColor,e.fillStyle=lt.textColor;n<-180;)n+=360;!ui&&n<0&&(n+=360);ui&&n>180&&(n=-(360-n));n>=0?(n="00"+Math.round(n),n=n.substring(n.length,n.length-3)):(n="00"+Math.abs(Math.round(n)),n="-"+n.substring(n.length,n.length-3));(lt===steelseries.LcdColor.STANDARD||lt===steelseries.LcdColor.STANDARD_GREEN)&&(e.shadowColor="gray",e.shadowOffsetX=f*.007,e.shadowOffsetY=f*.007,e.shadowBlur=f*.007);e.font=br?gr:dr;e.fillText(n+"°",f/2+ti*.05,(t?ur:fr)+ir*.5+ei*.38,ti*.9);e.restore()},lr=function(n,t,i,r,u){n.save();n.strokeStyle=r;n.fillStyle=r;n.lineWidth=f*.035;var e=nr/tr*t,o=e+(i-t)/(tr/nr);n.translate(b,k);n.rotate(kr);n.beginPath();u?(n.moveTo(0,0),n.arc(0,0,f*.365-n.lineWidth/2,e,o,!1)):n.arc(0,0,f*.365,e,o,!1);u?(n.moveTo(0,0),n.fill()):n.stroke();n.translate(-b,-k);n.restore()},nu=function(n){var l=f*.38,a=f*.35,p=f*.36,c=f*.1,v=f*.31,u=f*.36,r,e,t,o,y;if(n.textAlign="center",n.textBaseline="middle",n.save(),n.strokeStyle=rt.labelColor.getRgbaColor(),n.fillStyle=rt.labelColor.getRgbaColor(),n.translate(b,k),wr)for(r=Math.floor(.1*f)+"px serif bold",e=Math.floor(f*.04)+"px "+s,n.rotate(at*5),t=5;360>=t;t+=5){if(n.save(),yr)switch(t){case 360:n.translate(u,0);n.rotate(i);n.font=r;n.fillText(h[2],0,0,c);n.translate(-u,0);break;case 90:n.translate(u,0);n.rotate(i);n.font=r;n.fillText(h[4],0,0,c);n.translate(-u,0);break;case 180:n.translate(u,0);n.rotate(i);n.font=r;n.fillText(h[6],0,0,c);n.translate(-u,0);break;case 270:n.translate(u,0);n.rotate(i);n.font=r;n.fillText(h[0],0,0,c);n.translate(-u,0);break;case 5:case 85:case 95:case 175:case 185:case 265:case 275:case 355:break;default:(t+90)%20?(n.lineWidth=(t+90)%5?1.5:1,n.beginPath(),n.moveTo(l,0),y=(t+90)%10?p:a,n.lineTo(y,0),n.closePath(),n.stroke()):(n.lineWidth=1.5,n.beginPath(),n.moveTo(l,0),n.lineTo(a,0),n.closePath(),n.stroke(),o=(t+90)%360,n.translate(v,0),n.rotate(i),n.font=e,n.fillText("0".substring(o>=100)+o,0,0,c),n.translate(-v,0))}else(t+90)%20?(n.lineWidth=(t+90)%5?1.5:1,n.beginPath(),n.moveTo(l,0),y=(t+90)%10?p:a,n.lineTo(y,0),n.closePath(),n.stroke()):(n.lineWidth=1.5,n.beginPath(),n.moveTo(l,0),n.lineTo(a,0),n.closePath(),n.stroke(),o=(t+90)%360,ui&&o>180&&(o=-(360-o)),n.translate(v,0),n.rotate(i),n.font=e,n.fillText(o,0,0,c),n.translate(-v,0));n.restore();n.rotate(at*5)}else for(r=.12*f+"px serif",e=.06*f+"px serif",n.lineWidth=1,n.strokeStyle=rt.symbolColor.getRgbaColor(),t=0;360>t;t+=2.5){0==t%5&&(n.beginPath(),n.moveTo(f*.38,0),n.lineTo(f*.36,0),n.closePath(),n.stroke());n.save();switch(t){case 0:n.translate(f*.35,0);n.rotate(i);n.font=r;n.fillText(h[2],0,0);n.translate(-f*.35,0);break;case 45:n.translate(f*.29,0);n.rotate(i);n.font=e;n.fillText(h[3],0,0);n.translate(-f*.29,0);break;case 90:n.translate(f*.35,0);n.rotate(i);n.font=r;n.fillText(h[4],0,0);n.translate(-f*.35,0);break;case 135:n.translate(f*.29,0);n.rotate(i);n.font=e;n.fillText(h[5],0,0);n.translate(-f*.29,0);break;case 180:n.translate(f*.35,0);n.rotate(i);n.font=r;n.fillText(h[6],0,0);n.translate(-f*.35,0);break;case 225:n.translate(f*.29,0);n.rotate(i);n.font=e;n.fillText(h[7],0,0);n.translate(-f*.29,0);break;case 270:n.translate(f*.35,0);n.rotate(i);n.font=r;n.fillText(h[0],0,0);n.translate(-f*.35,0);break;case 315:n.translate(f*.29,0);n.rotate(i);n.font=e;n.fillText(h[1],0,0);n.translate(-f*.29,0)}n.restore();wi&&(0===t||22.5===t||45===t||67.5===t||90===t||112.5===t||135===t||157.5===t||180===t||202.5===t||225===t||247.5===t||270===t||292.5===t||315===t||337.5===t||360===t)&&(n.save(),n.beginPath(),t%45?n.moveTo(f*.29,0):n.moveTo(f*.38,0),n.lineTo(f*.1,0),n.closePath(),n.restore(),n.stroke());n.rotate(at*2.5)}n.translate(-b,-k);n.restore()},tu=function(n){gt.length>0&&(n.save(),n.textAlign="center",n.textBaseline="middle",n.fillStyle=di?ii.medium.getRgbaColor():rt.labelColor.getRgbaColor(),n.font=.04*f+"px "+s,n.fillText(gt[0],f/2,w*.29,f*.3),n.fillStyle=di?ri.medium.getRgbaColor():rt.labelColor.getRgbaColor(),n.fillText(gt[1],f/2,w*.71,f*.3),ki.length>0&&(n.fillStyle=rt.labelColor.getRgbaColor(),n.font=.0467*f+"px "+s,n.fillText(ki,f/2,w*.5,f*.3)))},a=function(n){var t,i,u;n=n||{};var r=undefined===n.background?!1:n.background,e=undefined===n.pointer?!1:n.pointer,o=undefined===n.foreground?!1:n.foreground;if(er=!0,r&&ci&&g(ut,hi,b,k,f,w),r&&li){if(nt(ut,rt,b,k,f,w),bt(ut,pr,b,k,f,w),null!==et&&0<et.length){t=et.length;do t--,lr(ut,et[t].start,et[t].stop,et[t].color,!1);while(0<t)}if(null!==ot&&0<ot.length){i=ot.length;do i--,lr(ut,ot[i].start,ot[i].stop,ot[i].color,!0);while(0<i)}nu(ut)}r&&wi&&pi(ut,b,k,f,w,rt);r&&bi&&(oi=it(ti,ir,lt),ut.drawImage(oi,rr,ur),ut.drawImage(oi,rr,fr),tu(ut));e&&(ft(sr,f,ai,ri,rt.labelColor),ft(or,f,dt,ii,rt.labelColor));o&&yi&&(u=dt.type==="type15"||dt.type==="type16"?!1:!0,tt(hr,vi,f,w,u,ar,vr))},d=function(n){n=n||{};var t=undefined===n.background?!1:n.background,i=undefined===n.pointer?!1:n.pointer,r=undefined===n.foreground?!1:n.foreground;t&&(vt.width=o,vt.height=o,ut=vt.getContext("2d"));i&&(yt.width=o,yt.height=o,or=yt.getContext("2d"),pt.width=o,pt.height=o,sr=pt.getContext("2d"));r&&(kt.width=o,kt.height=o,hr=kt.getContext("2d"))};return this.setValueLatest=function(n){return n=parseFloat(n),n=n===360?360:n%360,y!==n&&(y=n,this.repaint()),this},this.getValueLatest=function(){return y},this.setValueAverage=function(n){return n=parseFloat(n),n=n===360?360:n%360,p!==n&&(p=n,this.repaint()),this},this.getValueAverage=function(){return p},this.setValueAnimatedLatest=function(n,t){var i,f=this,r,u;return n=parseFloat(n),i=n===360?360:n%360,y!==i&&(undefined!==st&&st.isPlaying&&st.stop(),r=si(y,i),r!==0?(u=ni*Math.abs(r)/180,u=Math.max(u,ni/5),st=new Tween({},"",Tween.regularEaseInOut,y,y+r,u),st.onMotionChanged=function(n){y=n.target._pos===360?360:n.target._pos%360;l||(l=!0,v(f.repaint))},st.onMotionFinished=function(){y=i;l||(l=!0,v(f.repaint));t&&typeof t=="function"&&t()},st.start()):(y=i,l||(l=!0,v(f.repaint)))),this},this.setValueAnimatedAverage=function(n,t){var i,f=this,r,u;return n=parseFloat(n),i=n===360?360:n%360,p!==n&&(undefined!==ct&&ct.isPlaying&&ct.stop(),r=si(p,i),r!==0?(u=ni*Math.abs(r)/180,u=Math.max(u,ni/5),ct=new Tween({},"",Tween.regularEaseInOut,p,p+r,u),ct.onMotionChanged=function(n){p=n.target._pos===360?360:n.target._pos%360;l||(l=!0,v(f.repaint))},ct.onMotionFinished=function(){p=i;l||(l=!0,v(f.repaint));t&&typeof t=="function"&&t()},ct.start()):(p=i,l||(l=!0,v(f.repaint)))),this},this.setArea=function(n){return ot=n,d({background:!0}),a({background:!0}),this.repaint(),this},this.setSection=function(n){return et=n,d({background:!0}),a({background:!0}),this.repaint(),this},this.setFrameDesign=function(n){return hi=n,d({background:!0}),a({background:!0}),this.repaint(),this},this.setBackgroundColor=function(n){return rt=n,d({background:!0}),a({background:!0}),this.repaint(),this},this.setForegroundType=function(n){return d({foreground:!0}),vi=n,a({foreground:!0}),this.repaint(),this},this.setPointerColor=function(n){return d({pointer:!0}),ii=n,a({pointer:!0}),this.repaint(),this},this.setPointerColorAverage=function(n){return d({pointer:!0}),ri=n,a({pointer:!0}),this.repaint(),this},this.setPointerType=function(n){return dt=n,d({pointer:!0,foreground:!0}),a({pointer:!0,foreground:!0}),this.repaint(),this},this.setPointerTypeAverage=function(n){return ai=n,d({pointer:!0,foreground:!0}),a({pointer:!0,foreground:!0}),this.repaint(),this},this.setPointSymbols=function(n){return h=n,d({background:!0}),a({background:!0}),this.repaint(),this},this.setLcdColor=function(n){return lt=n,d({background:!0}),a({background:!0}),this.repaint(),this},this.setLcdTitleStrings=function(n){return gt=n,d({background:!0}),a({background:!0}),this.repaint(),this},this.repaint=function(){er||a({frame:!0,background:!0,led:!0,pointer:!0,foreground:!0});e.clearRect(0,0,e.canvas.width,e.canvas.height);(ci||li)&&e.drawImage(vt,0,0);bi&&(cr(y,!0),cr(p,!1));fi=p*at;var n=f*.006;e.save();e.translate(b,k);e.rotate(fi);e.translate(-b,-k);e.shadowColor="rgba(0, 0, 0, 0.8)";e.shadowOffsetX=e.shadowOffsetY=n;e.shadowBlur=n*2;e.drawImage(pt,0,0);gi=y*at-fi;e.translate(b,k);e.rotate(gi);e.translate(-b,-k);e.drawImage(yt,0,0);e.restore();yi&&e.drawImage(kt,0,0);l=!1},this.repaint(),this},vi=function(n,t){var c,f,o,u,s;t=t||{};var i=undefined===t.size?0:t.size,v=undefined===t.ledColor?steelseries.LedColor.RED_LED:t.ledColor,h=!1,y=0,r=ht(n);i===0&&(i=Math.min(r.canvas.width,r.canvas.height));r.canvas.width=i;r.canvas.height=i;c=!1;f=d.createElement("canvas");f.width=i;f.height=i;o=f.getContext("2d");u=d.createElement("canvas");u.width=i;u.height=i;var l=u.getContext("2d"),e=u,p=function(){c=!0;o.clearRect(0,0,o.canvas.width,o.canvas.height);o.drawImage(a(i,1,v),0,0);l.clearRect(0,0,l.canvas.width,l.canvas.height);l.drawImage(a(i,0,v),0,0)};return this.toggleLed=function(){return e=e===f?u:f,s(),this},this.setLedColor=function(n){return v=n,c=!1,s(),this},this.setLedOnOff=function(n){return e=n?f:u,s(),this},this.blink=function(n){return n?h||(y=setInterval(this.toggleLed,1e3),h=!0):h&&(clearInterval(y),h=!1,e=u),this},s=function(){c||p();r.save();r.clearRect(0,0,r.canvas.width,r.canvas.height);r.drawImage(e,0,0);r.restore()},s(),this},yi=function(n,t){function pt(){var t,n;for(st=!0,p.rect(0,0,l,e),t=p.createLinearGradient(0,0,0,e),t.addColorStop(0,"rgba(0, 0, 0, 1)"),t.addColorStop(.1,"rgba(0, 0, 0, 0.4)"),t.addColorStop(.33,"rgba(255, 255, 255, 0.45)"),t.addColorStop(.46,"rgba(255, 255, 255, 0)"),t.addColorStop(.9,"rgba(0, 0, 0, 0.4)"),t.addColorStop(1,"rgba(0, 0, 0, 1)"),p.fillStyle=t,p.fill(),i.rect(0,0,f,s*1.1),i.fillStyle=vt,i.fill(),i.strokeStyle="#f0f0f0",i.lineWidth="1px",i.moveTo(0,0),i.lineTo(0,s*1.1),i.stroke(),i.strokeStyle="#202020",i.moveTo(f,0),i.lineTo(f,s*1.1),i.stroke(),i.textAlign="center",i.textBaseline="middle",i.font=g,i.fillStyle=yt,n=9;n<21;n++)i.fillText(n%10,f*.5,h*(n-9)+h/2);if(a>0)for(u.rect(0,0,f,s*1.1),u.fillStyle=ct,u.fill(),u.strokeStyle="#f0f0f0",u.lineWidth="1px",u.moveTo(0,0),u.lineTo(0,s*1.1),u.stroke(),u.strokeStyle="#202020",u.moveTo(f,0),u.lineTo(f,s*1.1),u.stroke(),u.textAlign="center",u.textBaseline="middle",u.font=g,u.fillStyle=lt,n=9;n<21;n++)u.fillText(n%10,f*.5,h*(n-9)+h/2);for(n=0;n<b+a;n++)tt[n]=Math.random()*ot*e-ot*e/2}function wt(){for(var u=1,e=o,i,t,r,s,n=0;n<a;n++)e*=10;for(t=Math.floor(e),r=e-t,t=String(t),s=9,n=0;n<a+b;n++)i=+t.substring(t.length-n-1,t.length-n)||0,s!==9&&(r=0),n<a?w.drawImage(ft,l-f*u,-(h*(i+r)+nt+tt[n])):w.drawImage(ut,l-f*u,-(h*(i+r)+nt+tt[n])),u++,s=i}t=t||{};var et=undefined===t._context?null:t._context,e=undefined===t.height?0:t.height,b=undefined===t.digits?6:t.digits,a=undefined===t.decimals?1:t.decimals,ct=undefined===t.decimalBackColor?"#F0F0F0":t.decimalBackColor,lt=undefined===t.decimalForeColor?"#F01010":t.decimalForeColor,at=undefined===t.font?"sans-serif":t.font,o=undefined===t.value?0:t.value,vt=undefined===t.valueBackColor?"#050505":t.valueBackColor,yt=undefined===t.valueForeColor?"#F8F8F8":t.valueForeColor,ot=undefined===t.wobbleFactor?.07:t.wobbleFactor,st=!1,c,y,k=!1,d,f,g,l,s,h,nt,tt=[],it,w,rt,p,ut,i,ft,u;y=et?et:ht(n);e===0&&(e=y.canvas.height);o<0&&(o=0);d=Math.floor(e*.85);g="600 "+d+"px "+at;f=Math.floor(e*.68);l=f*(b+a);s=d*11;h=s/12;nt=h*.81;y.canvas.width=l;y.canvas.height=e;it=r(l,e);w=it.getContext("2d");rt=r(l,e);p=rt.getContext("2d");ut=r(f,s*1.1);i=ut.getContext("2d");ft=r(f,s*1.1);u=ft.getContext("2d");this.setValueAnimated=function(n,t){var i=this;return n=parseFloat(n),n<0&&(n=0),o!==n&&(undefined!==c&&c.isPlaying&&c.stop(),c=new Tween({},"",Tween.strongEaseOut,o,n,2),c.onMotionChanged=function(n){o=n.target._pos;k||(k=!0,v(i.repaint))},t&&typeof t=="function"&&(c.onMotionFinished=t),c.start()),this.repaint(),this};this.setValue=function(n){return o=parseFloat(n),o<0&&(o=0),this.repaint(),this};this.getValue=function(){return o};this.repaint=function(){st||pt();wt();w.drawImage(rt,0,0);y.drawImage(it,0,0);k=!1};this.repaint()},pi=function(n,i,r,u,f,e){var l=!0,o,s,h=e.symbolColor.getRgbaColor();for(n.save(),n.lineWidth=1,n.fillStyle=h,n.strokeStyle=h,n.translate(i,r),o=0;o<360;o+=15)l=!l,n.beginPath(),n.arc(0,0,u*.26,o*c,(o+15)*c,!1),n.arc(0,0,u*.23,(o+15)*c,o*c,!0),n.closePath(),l&&n.fill(),n.stroke();for(n.translate(-i,-r),o=0;360>=o;o+=90)n.beginPath(),n.moveTo(u*.560747,f*.584112),n.lineTo(u*.640186,f*.644859),n.lineTo(u*.584112,f*.560747),n.lineTo(u*.560747,f*.584112),n.closePath(),n.fillStyle=h,n.fill(),n.stroke(),n.beginPath(),n.moveTo(u*.523364,f*.397196),n.lineTo(u*.5,f*.196261),n.lineTo(u*.471962,f*.397196),n.lineTo(u*.523364,f*.397196),n.closePath(),s=n.createLinearGradient(.476635*u,0,.518691*u,0),s.addColorStop(0,"rgb(222, 223, 218)"),s.addColorStop(.48,"rgb(222, 223, 218)"),s.addColorStop(.49,h),s.addColorStop(1,h),n.fillStyle=s,n.fill(),n.stroke(),n.translate(i,r),n.rotate(o*c),n.translate(-i,-r);n.beginPath();n.translate(i,r);n.arc(0,0,u*.1,0,t,!1);n.lineWidth=u*.022;n.stroke();n.translate(-i,-r);n.restore()},ft=function(n,i,u,f,e){var c,o,s,h,l=i.toString()+u.type+f.light.getHexColor()+f.medium.getHexColor();if(!ft.cache[l]){c=r(i,i);o=c.getContext("2d");switch(u.type){case"type2":s=o.createLinearGradient(0,i*.471962,0,i*.130841);s.addColorStop(0,e.getRgbaColor());s.addColorStop(.36,e.getRgbaColor());s.addColorStop(.361,f.light.getRgbaColor());s.addColorStop(1,f.light.getRgbaColor());o.fillStyle=s;o.beginPath();o.moveTo(i*.518691,i*.471962);o.lineTo(i*.509345,i*.462616);o.lineTo(i*.509345,i*.341121);o.lineTo(i*.504672,i*.130841);o.lineTo(i*.495327,i*.130841);o.lineTo(i*.490654,i*.341121);o.lineTo(i*.490654,i*.462616);o.lineTo(i*.481308,i*.471962);o.closePath();o.fill();break;case"type3":o.beginPath();o.rect(i*.495327,i*.130841,i*.009345,i*.373831);o.closePath();o.fillStyle=f.light.getRgbaColor();o.fill();break;case"type4":s=o.createLinearGradient(.467289*i,0,.528036*i,0);s.addColorStop(0,f.dark.getRgbaColor());s.addColorStop(.51,f.dark.getRgbaColor());s.addColorStop(.52,f.light.getRgbaColor());s.addColorStop(1,f.light.getRgbaColor());o.fillStyle=s;o.beginPath();o.moveTo(i*.5,i*.126168);o.lineTo(i*.514018,i*.135514);o.lineTo(i*.53271,i*.5);o.lineTo(i*.523364,i*.602803);o.lineTo(i*.476635,i*.602803);o.lineTo(i*.467289,i*.5);o.lineTo(i*.485981,i*.135514);o.lineTo(i*.5,i*.126168);o.closePath();o.fill();break;case"type5":s=o.createLinearGradient(.471962*i,0,.528036*i,0);s.addColorStop(0,f.light.getRgbaColor());s.addColorStop(.5,f.light.getRgbaColor());s.addColorStop(.5,f.medium.getRgbaColor());s.addColorStop(1,f.medium.getRgbaColor());o.fillStyle=s;o.beginPath();o.moveTo(i*.5,i*.495327);o.lineTo(i*.528037,i*.495327);o.lineTo(i*.5,i*.149532);o.lineTo(i*.471962,i*.495327);o.lineTo(i*.5,i*.495327);o.closePath();o.fill();o.lineWidth=1;o.lineCap="square";o.lineJoin="miter";o.strokeStyle=f.dark.getRgbaColor();o.stroke();break;case"type6":o.fillStyle=f.medium.getRgbaColor();o.beginPath();o.moveTo(i*.481308,i*.485981);o.lineTo(i*.481308,i*.392523);o.lineTo(i*.485981,i*.317757);o.lineTo(i*.495327,i*.130841);o.lineTo(i*.504672,i*.130841);o.lineTo(i*.514018,i*.317757);o.lineTo(i*.518691,i*.38785);o.lineTo(i*.518691,i*.485981);o.lineTo(i*.504672,i*.485981);o.lineTo(i*.504672,i*.38785);o.lineTo(i*.5,i*.317757);o.lineTo(i*.495327,i*.392523);o.lineTo(i*.495327,i*.485981);o.lineTo(i*.481308,i*.485981);o.closePath();o.fill();break;case"type7":s=o.createLinearGradient(.481308*i,0,.518691*i,0);s.addColorStop(0,f.dark.getRgbaColor());s.addColorStop(1,f.medium.getRgbaColor());o.fillStyle=s;o.beginPath();o.moveTo(i*.490654,i*.130841);o.lineTo(i*.481308,i*.5);o.lineTo(i*.518691,i*.5);o.lineTo(i*.504672,i*.130841);o.lineTo(i*.490654,i*.130841);o.closePath();o.fill();break;case"type8":s=o.createLinearGradient(.471962*i,0,.528036*i,0);s.addColorStop(0,f.light.getRgbaColor());s.addColorStop(.5,f.light.getRgbaColor());s.addColorStop(.5,f.medium.getRgbaColor());s.addColorStop(1,f.medium.getRgbaColor());o.fillStyle=s;o.strokeStyle=f.dark.getRgbaColor();o.beginPath();o.moveTo(i*.5,i*.53271);o.lineTo(i*.53271,i*.5);o.bezierCurveTo(i*.53271,i*.5,i*.509345,i*.457943,i*.5,i*.149532);o.bezierCurveTo(i*.490654,i*.457943,i*.467289,i*.5,i*.467289,i*.5);o.lineTo(i*.5,i*.53271);o.closePath();o.fill();o.stroke();break;case"type9":s=o.createLinearGradient(.471962*i,0,.528036*i,0);s.addColorStop(0,"rgb(50, 50, 50)");s.addColorStop(.5,"#666666");s.addColorStop(1,"rgb(50, 50, 50)");o.fillStyle=s;o.strokeStyle="#2E2E2E";o.beginPath();o.moveTo(i*.495327,i*.233644);o.lineTo(i*.504672,i*.233644);o.lineTo(i*.514018,i*.439252);o.lineTo(i*.485981,i*.439252);o.lineTo(i*.495327,i*.233644);o.closePath();o.moveTo(i*.490654,i*.130841);o.lineTo(i*.471962,i*.471962);o.lineTo(i*.471962,i*.528037);o.bezierCurveTo(i*.471962,i*.528037,i*.476635,i*.602803,i*.476635,i*.602803);o.bezierCurveTo(i*.476635,i*.607476,i*.481308,i*.607476,i*.5,i*.607476);o.bezierCurveTo(i*.518691,i*.607476,i*.523364,i*.607476,i*.523364,i*.602803);o.bezierCurveTo(i*.523364,i*.602803,i*.528037,i*.528037,i*.528037,i*.528037);o.lineTo(i*.528037,i*.471962);o.lineTo(i*.509345,i*.130841);o.lineTo(i*.490654,i*.130841);o.closePath();o.fill();o.beginPath();o.moveTo(i*.495327,i*.219626);o.lineTo(i*.504672,i*.219626);o.lineTo(i*.504672,i*.135514);o.lineTo(i*.495327,i*.135514);o.lineTo(i*.495327,i*.219626);o.closePath();o.fillStyle=f.medium.getRgbaColor();o.fill();break;case"type10":o.beginPath();o.moveTo(i*.5,i*.149532);o.bezierCurveTo(i*.5,i*.149532,i*.443925,i*.490654,i*.443925,i*.5);o.bezierCurveTo(i*.443925,i*.53271,i*.467289,i*.556074,i*.5,i*.556074);o.bezierCurveTo(i*.53271,i*.556074,i*.556074,i*.53271,i*.556074,i*.5);o.bezierCurveTo(i*.556074,i*.490654,i*.5,i*.149532,i*.5,i*.149532);o.closePath();s=o.createLinearGradient(.471962*i,0,.528036*i,0);s.addColorStop(0,f.light.getRgbaColor());s.addColorStop(.5,f.light.getRgbaColor());s.addColorStop(.5,f.medium.getRgbaColor());s.addColorStop(1,f.medium.getRgbaColor());o.fillStyle=s;o.strokeStyle=f.medium.getRgbaColor();o.lineWidth=1;o.lineCap="square";o.lineJoin="miter";o.fill();o.stroke();break;case"type11":o.beginPath();o.moveTo(.5*i,.168224*i);o.lineTo(.485981*i,.5*i);o.bezierCurveTo(.485981*i,.5*i,.481308*i,.584112*i,.5*i,.584112*i);o.bezierCurveTo(.514018*i,.584112*i,.509345*i,.5*i,.509345*i,.5*i);o.lineTo(.5*i,.168224*i);o.closePath();s=o.createLinearGradient(0,.168224*i,0,.584112*i);s.addColorStop(0,f.medium.getRgbaColor());s.addColorStop(1,f.dark.getRgbaColor());o.fillStyle=s;o.strokeStyle=f.dark.getRgbaColor();o.fill();o.stroke();break;case"type12":o.beginPath();o.moveTo(.5*i,.168224*i);o.lineTo(.485981*i,.5*i);o.lineTo(.5*i,.504672*i);o.lineTo(.509345*i,.5*i);o.lineTo(.5*i,.168224*i);o.closePath();s=o.createLinearGradient(0,.168224*i,0,.504672*i);s.addColorStop(0,f.medium.getRgbaColor());s.addColorStop(1,f.dark.getRgbaColor());o.fillStyle=s;o.strokeStyle=f.dark.getRgbaColor();o.fill();o.stroke();break;case"type13":case"type14":o.beginPath();o.moveTo(.485981*i,.168224*i);o.lineTo(.5*i,.130841*i);o.lineTo(.509345*i,.168224*i);o.lineTo(.509345*i,.509345*i);o.lineTo(.485981*i,.509345*i);o.lineTo(.485981*i,.168224*i);o.closePath();u.type==="type13"?(s=o.createLinearGradient(0,.5*i,0,.130841*i),s.addColorStop(0,e.getRgbaColor()),s.addColorStop(.85,e.getRgbaColor()),s.addColorStop(.85,f.medium.getRgbaColor()),s.addColorStop(1,f.medium.getRgbaColor()),o.fillStyle=s):(s=o.createLinearGradient(.485981*i,0,.509345*i,0),s.addColorStop(0,f.veryDark.getRgbaColor()),s.addColorStop(.5,f.light.getRgbaColor()),s.addColorStop(1,f.veryDark.getRgbaColor()),o.fillStyle=s);o.fill();break;case"type15":case"type16":o.beginPath();o.moveTo(i*.509345,i*.457943);o.lineTo(i*.5015,i*.13);o.lineTo(i*.4985,i*.13);o.lineTo(i*.490654,i*.457943);o.bezierCurveTo(i*.490654,i*.457943,i*.490654,i*.457943,i*.490654,i*.457943);o.bezierCurveTo(i*.471962,i*.462616,i*.457943,i*.481308,i*.457943,i*.5);o.bezierCurveTo(i*.457943,i*.518691,i*.471962,i*.537383,i*.490654,i*.542056);o.bezierCurveTo(i*.490654,i*.542056,i*.490654,i*.542056,i*.490654,i*.542056);u.type==="type15"?(o.lineTo(i*.490654,i*.57),o.bezierCurveTo(i*.46,i*.58,i*.46,i*.62,i*.490654,i*.63),o.bezierCurveTo(i*.47,i*.62,i*.48,i*.59,i*.5,i*.59),o.bezierCurveTo(i*.53,i*.59,i*.52,i*.62,i*.509345,i*.63),o.bezierCurveTo(i*.54,i*.62,i*.54,i*.58,i*.509345,i*.57),o.lineTo(i*.509345,i*.57)):(o.lineTo(i*.490654,i*.621495),o.lineTo(i*.509345,i*.621495));o.lineTo(i*.509345,i*.542056);o.bezierCurveTo(i*.509345,i*.542056,i*.509345,i*.542056,i*.509345,i*.542056);o.bezierCurveTo(i*.528037,i*.537383,i*.542056,i*.518691,i*.542056,i*.5);o.bezierCurveTo(i*.542056,i*.481308,i*.528037,i*.462616,i*.509345,i*.457943);o.bezierCurveTo(i*.509345,i*.457943,i*.509345,i*.457943,i*.509345,i*.457943);o.closePath();s=u.type==="type15"?o.createLinearGradient(0,0,0,i*.63):o.createLinearGradient(0,0,0,i*.621495);s.addColorStop(0,f.medium.getRgbaColor());s.addColorStop(.388888,f.medium.getRgbaColor());s.addColorStop(.5,f.light.getRgbaColor());s.addColorStop(.611111,f.medium.getRgbaColor());s.addColorStop(1,f.medium.getRgbaColor());o.fillStyle=s;o.strokeStyle=f.dark.getRgbaColor();o.fill();o.stroke();o.beginPath();h=i*.06542/2;o.arc(i*.5,i*.5,h,0,t);s=o.createLinearGradient(i*.5-h,i*.5+h,0,i*.5+h);s.addColorStop(0,"#e6b35c");s.addColorStop(.01,"#e6b35c");s.addColorStop(.99,"#c48200");s.addColorStop(1,"#c48200");o.fillStyle=s;o.closePath();o.fill();o.beginPath();h=i*.046728/2;o.arc(i*.5,i*.5,h,0,t);s=o.createRadialGradient(i*.5,i*.5,0,i*.5,i*.5,h);s.addColorStop(0,"#c5c5c5");s.addColorStop(.19,"#c5c5c5");s.addColorStop(.22,"#000000");s.addColorStop(.8,"#000000");s.addColorStop(.99,"#707070");s.addColorStop(1,"#707070");o.fillStyle=s;o.closePath();o.fill();break;case"type1":default:s=o.createLinearGradient(0,i*.471962,0,i*.130841);s.addColorStop(0,f.veryDark.getRgbaColor());s.addColorStop(.3,f.medium.getRgbaColor());s.addColorStop(.59,f.medium.getRgbaColor());s.addColorStop(1,f.veryDark.getRgbaColor());o.fillStyle=s;o.beginPath();o.moveTo(i*.518691,i*.471962);o.bezierCurveTo(i*.514018,i*.457943,i*.509345,i*.415887,i*.509345,i*.401869);o.bezierCurveTo(i*.504672,i*.383177,i*.5,i*.130841,i*.5,i*.130841);o.bezierCurveTo(i*.5,i*.130841,i*.490654,i*.383177,i*.490654,i*.397196);o.bezierCurveTo(i*.490654,i*.415887,i*.485981,i*.457943,i*.481308,i*.471962);o.bezierCurveTo(i*.471962,i*.481308,i*.467289,i*.490654,i*.467289,i*.5);o.bezierCurveTo(i*.467289,i*.518691,i*.481308,i*.53271,i*.5,i*.53271);o.bezierCurveTo(i*.518691,i*.53271,i*.53271,i*.518691,i*.53271,i*.5);o.bezierCurveTo(i*.53271,i*.490654,i*.528037,i*.481308,i*.518691,i*.471962);o.closePath();o.fill()}ft.cache[l]=c}return n.drawImage(ft.cache[l],0,0),this},g,nt,bt,tt,l,a,it,et,w,v,e,f,y,ut,ct,vt,ui,gt,b,h,lt,ni,ti,yt;ft.cache={};g=function(i,u,f,e,o,s){var p,h,c,l,a,v,y,w=o.toString()+s+u.design;if(!g.cache[w]){p=r(o,s);h=p.getContext("2d");h.fillStyle="#848484";h.strokeStyle="rgba(132, 132, 132, 0.5)";h.beginPath();h.arc(f,e,o/2,0,t,!0);h.closePath();h.fill();h.stroke();h.beginPath();h.arc(f,e,o*.990654/2,0,t,!0);h.closePath();switch(u.design){case"metal":c=h.createLinearGradient(0,o*.004672,0,s*.990654);c.addColorStop(0,"#fefefe");c.addColorStop(.07,"rgb(210, 210, 210)");c.addColorStop(.12,"rgb(179, 179, 179)");c.addColorStop(1,"rgb(213, 213, 213)");h.fillStyle=c;h.fill();break;case"brass":c=h.createLinearGradient(0,o*.004672,0,s*.990654);c.addColorStop(0,"rgb(249, 243, 155)");c.addColorStop(.05,"rgb(246, 226, 101)");c.addColorStop(.1,"rgb(240, 225, 132)");c.addColorStop(.5,"rgb(90, 57, 22)");c.addColorStop(.9,"rgb(249, 237, 139)");c.addColorStop(.95,"rgb(243, 226, 108)");c.addColorStop(1,"rgb(202, 182, 113)");h.fillStyle=c;h.fill();break;case"steel":c=h.createLinearGradient(0,o*.004672,0,s*.990654);c.addColorStop(0,"rgb(231, 237, 237)");c.addColorStop(.05,"rgb(189, 199, 198)");c.addColorStop(.1,"rgb(192, 201, 200)");c.addColorStop(.5,"rgb(23, 31, 33)");c.addColorStop(.9,"rgb(196, 205, 204)");c.addColorStop(.95,"rgb(194, 204, 203)");c.addColorStop(1,"rgb(189, 201, 199)");h.fillStyle=c;h.fill();break;case"gold":c=h.createLinearGradient(0,o*.004672,0,s*.990654);c.addColorStop(0,"rgb(255, 255, 207)");c.addColorStop(.15,"rgb(255, 237, 96)");c.addColorStop(.22,"rgb(254, 199, 57)");c.addColorStop(.3,"rgb(255, 249, 203)");c.addColorStop(.38,"rgb(255, 199, 64)");c.addColorStop(.44,"rgb(252, 194, 60)");c.addColorStop(.51,"rgb(255, 204, 59)");c.addColorStop(.6,"rgb(213, 134, 29)");c.addColorStop(.68,"rgb(255, 201, 56)");c.addColorStop(.75,"rgb(212, 135, 29)");c.addColorStop(1,"rgb(247, 238, 101)");h.fillStyle=c;h.fill();break;case"anthracite":c=h.createLinearGradient(0,.004672*s,0,.995326*s);c.addColorStop(0,"rgb(118, 117, 135)");c.addColorStop(.06,"rgb(74, 74, 82)");c.addColorStop(.12,"rgb(50, 50, 54)");c.addColorStop(1,"rgb(79, 79, 87)");h.fillStyle=c;h.fill();break;case"tiltedGray":c=h.createLinearGradient(.233644*o,.084112*s,.81258*o,.910919*s);c.addColorStop(0,"#ffffff");c.addColorStop(.07,"rgb(210, 210, 210)");c.addColorStop(.16,"rgb(179, 179, 179)");c.addColorStop(.33,"#ffffff");c.addColorStop(.55,"#c5c5c5");c.addColorStop(.79,"#ffffff");c.addColorStop(1,"#666666");h.fillStyle=c;h.fill();break;case"tiltedBlack":c=h.createLinearGradient(.228971*o,.079439*s,.802547*o,.898591*s);c.addColorStop(0,"#666666");c.addColorStop(.21,"#000000");c.addColorStop(.47,"#666666");c.addColorStop(.99,"#000000");c.addColorStop(1,"#000000");h.fillStyle=c;h.fill();break;case"glossyMetal":c=h.createRadialGradient(.5*o,.5*s,0,.5*o,.5*o,.5*o);c.addColorStop(0,"rgb(207, 207, 207)");c.addColorStop(.96,"rgb(205, 204, 205)");c.addColorStop(1,"rgb(244, 244, 244)");h.fillStyle=c;h.fill();h.beginPath();h.arc(.5*o,.5*s,.973962*o/2,0,t);h.closePath();c=h.createLinearGradient(0,s-.971962*s,0,.971962*s);c.addColorStop(0,"rgb(249, 249, 249)");c.addColorStop(.23,"rgb(200, 195, 191)");c.addColorStop(.36,"#ffffff");c.addColorStop(.59,"rgb(29, 29, 29)");c.addColorStop(.76,"rgb(200, 194, 192)");c.addColorStop(1,"rgb(209, 209, 209)");h.fillStyle=c;h.fill();h.beginPath();h.arc(.5*o,.5*s,.869158*o/2,0,t);h.closePath();h.fillStyle="#f6f6f6";h.fill();h.beginPath();h.arc(.5*o,.5*s,.85*o/2,0,t);h.closePath();h.fillStyle="#333333";h.fill();break;case"blackMetal":v=[0,.125,.347222,.5,.680555,.875,1];y=[new n(254,254,254,1),new n(0,0,0,1),new n(153,153,153,1),new n(0,0,0,1),new n(153,153,153,1),new n(0,0,0,1),new n(254,254,254,1)];h.save();h.arc(f,e,o*.990654/2,0,t,!0);h.clip();l=o*.495327;a=o*.42056;c=new at(v,y);c.fillCircle(h,f,e,a,l);h.strokeStyle="#848484";h.strokeStyle="rgba(132, 132, 132, 0.8)";h.beginPath();h.lineWidth=o/90;h.arc(f,e,o/2,0,t,!0);h.closePath();h.stroke();h.restore();break;case"shinyMetal":v=[0,.125,.25,.347222,.5,.652777,.75,.875,1];y=[new n(254,254,254,1),new n(210,210,210,1),new n(179,179,179,1),new n(238,238,238,1),new n(160,160,160,1),new n(238,238,238,1),new n(179,179,179,1),new n(210,210,210,1),new n(254,254,254,1)];h.save();h.arc(f,e,o*.990654/2,0,t,!0);h.clip();l=o*.495327;a=o*.42056;c=new at(v,y);c.fillCircle(h,f,e,a,l);h.strokeStyle="#848484";h.strokeStyle="rgba(132, 132, 132, 0.8)";h.beginPath();h.lineWidth=o/90;h.arc(f,e,o/2,0,t,!0);h.closePath();h.stroke();h.restore();break;case"chrome":v=[0,.09,.12,.16,.25,.29,.33,.38,.48,.52,.63,.68,.8,.83,.87,.97,1];y=[new n(255,255,255,1),new n(255,255,255,1),new n(136,136,138,1),new n(164,185,190,1),new n(158,179,182,1),new n(112,112,112,1),new n(221,227,227,1),new n(155,176,179,1),new n(156,176,177,1),new n(254,255,255,1),new n(255,255,255,1),new n(156,180,180,1),new n(198,209,211,1),new n(246,248,247,1),new n(204,216,216,1),new n(164,188,190,1),new n(255,255,255,1)];h.save();h.arc(f,e,o*.990654/2,0,t,!0);h.clip();l=o*.495327;a=o*.42056;c=new at(v,y);c.fillCircle(h,f,e,a,l);h.strokeStyle="#848484";h.strokeStyle="rgba(132, 132, 132, 0.8)";h.beginPath();h.lineWidth=o/90;h.arc(f,e,o/2,0,t,!0);h.closePath();h.stroke();h.restore()}h.fillStyle="rgb(191, 191, 191)";h.beginPath();h.arc(f,e,o*.841121/2,0,t,!0);h.closePath();h.fill();h.globalCompositeOperation="destination-out";h.beginPath();h.arc(f,e,o*.83/2,0,t,!0);h.closePath();h.fill();g.cache[w]=p}return i.drawImage(g.cache[w],0,0),this};g.cache={};nt=function(i,u,f,e,o,s){var w,h,l,d,g,a=o*.831775/2,tt,it,rt,p,y,v,ut,b,k=o.toString()+s+u.name;if(!nt.cache[k]){if(w=r(o,s),h=w.getContext("2d"),h.beginPath(),h.arc(f,e,a,0,t,!0),h.closePath(),u.name==="CARBON"||u.name==="PUNCHED_SHEET"||u.name==="BRUSHED_METAL"||u.name==="BRUSHED_STAINLESS")u.name==="CARBON"&&(h.fillStyle=h.createPattern(wi,"repeat"),h.fill()),u.name==="PUNCHED_SHEET"&&(h.fillStyle=h.createPattern(bi,"repeat"),h.fill()),l=h.createLinearGradient(a,0,o-a,0),l.addColorStop(0,"rgba(0, 0, 0, 0.25)"),l.addColorStop(.5,"rgba(0, 0, 0, 0)"),l.addColorStop(1,"rgba(0, 0, 0, 0.25)"),h.fillStyle=l,h.beginPath(),h.arc(f,e,a,0,t,!0),h.closePath(),h.fill(),(u.name==="BRUSHED_METAL"||u.name==="BRUSHED_STAINLESS")&&(tt=u.name==="BRUSHED_METAL"?!0:!1,it=parseInt(u.gradientStop.getHexColor().substr(-6),16),rt=ki(it,5,.1,tt,.5),h.fillStyle=h.createPattern(rt.fill(0,0,o,s),"no-repeat"),h.fill());else if(u.name==="STAINLESS"||u.name==="TURNED"){if(d=[0,.03,.1,.14,.24,.33,.38,.5,.62,.67,.76,.81,.85,.97,1],g=[new n("#FDFDFD"),new n("#FDFDFD"),new n("#B2B2B4"),new n("#ACACAE"),new n("#FDFDFD"),new n("#8E8E8E"),new n("#8E8E8E"),new n("#FDFDFD"),new n("#8E8E8E"),new n("#8E8E8E"),new n("#FDFDFD"),new n("#ACACAE"),new n("#B2B2B4"),new n("#FDFDFD"),new n("#FDFDFD")],l=new at(d,g),l.fillCircle(h,f,e,0,a),u.name==="TURNED"){for(p=a,y=p*.55,v=c*(500/p),h.save(),h.beginPath(),h.arc(f,e,p,0,t),h.closePath(),h.clip(),h.lineWidth=.5,ut=t-v*.3,b=0;b<ut;b+=v)h.strokeStyle="rgba(240, 240, 255, 0.25)",h.beginPath(),h.arc(f+y,e,y,0,t),h.stroke(),h.translate(f,e),h.rotate(v*.3),h.translate(-f,-e),h.strokeStyle="rgba(25, 10, 10, 0.1)",h.beginPath(),h.arc(f+y,e,y,0,t),h.stroke(),h.translate(f,e),h.rotate(v-v*.3),h.translate(-f,-e);h.restore()}}else l=h.createLinearGradient(0,o*.084112,0,a*2),l.addColorStop(0,u.gradientStart.getRgbaColor()),l.addColorStop(.4,u.gradientFraction.getRgbaColor()),l.addColorStop(1,u.gradientStop.getRgbaColor()),h.fillStyle=l,h.fill();l=h.createRadialGradient(f,e,0,f,e,a);l.addColorStop(0,"rgba(0, 0, 0, 0)");l.addColorStop(.7,"rgba(0, 0, 0, 0)");l.addColorStop(.71,"rgba(0, 0, 0, 0)");l.addColorStop(.86,"rgba(0, 0, 0, 0.03)");l.addColorStop(.92,"rgba(0, 0, 0, 0.07)");l.addColorStop(.97,"rgba(0, 0, 0, 0.15)");l.addColorStop(1,"rgba(0, 0, 0, 0.3)");h.fillStyle=l;h.beginPath();h.arc(f,e,a,0,t,!0);h.closePath();h.fill();nt.cache[k]=w}return i.drawImage(nt.cache[k],0,0),this};nt.cache={};bt=function(n,i,r,u,f,e){var o=f*.831775,s=e*.831775,h=(f-o)/2,c=(e-s)/2;return i!==null&&i.height>0&&i.width>0&&(n.save(),n.beginPath(),n.arc(r,u,f*.831775/2,0,t,!0),n.clip(),n.drawImage(i,h,c,o,s),n.restore()),this};tt=function(n,t,i,u,f,e,o,s,h){var b,c,v=Math.ceil(u*.084112),y=i*.5-v/2,p=u*.5-v/2,d=i*.008,a,w,k=t.type+i+u+f+(e!==undefined?e.type:"-")+(o!==undefined?o.style:"-")+(h!==undefined?h.type:"-");if(!tt.cache[k]){b=r(i,u);c=b.getContext("2d");f&&(c.shadowColor="rgba(0, 0, 0, 0.8)",c.shadowOffsetX=c.shadowOffsetY=d,c.shadowBlur=d*2,s===steelseries.GaugeType.TYPE5?steelseries.Orientation.WEST===h?(y=i*.733644-v/2,c.drawImage(l(v,e,o),y,p)):steelseries.Orientation.EAST===h?(y=i*(1-.733644)-v/2,c.drawImage(l(v,e,o),y,p)):(p=u*.733644-v/2,c.drawImage(l(v,e,o),y,u*.6857)):c.drawImage(l(v,e,o),y,p),c.shadowOffsetX=c.shadowOffsetY=0,c.shadowBlur=0);switch(t.type){case"type2":c.beginPath();c.moveTo(i*.135514,u*.696261);c.bezierCurveTo(i*.214953,u*.588785,i*.317757,u*.5,i*.462616,u*.425233);c.bezierCurveTo(i*.612149,u*.345794,i*.733644,u*.317757,i*.873831,u*.322429);c.bezierCurveTo(i*.766355,u*.112149,i*.528037,u*.023364,i*.313084,u*.130841);c.bezierCurveTo(i*.09813,u*.238317,i*.028037,u*.485981,i*.135514,u*.696261);c.closePath();a=c.createLinearGradient(.313084*i,.135514*u,.495528*i,.493582*u);a.addColorStop(0,"rgba(255, 255, 255, 0.275)");a.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type3":c.beginPath();c.moveTo(i*.084112,u*.509345);c.bezierCurveTo(i*.21028,u*.556074,i*.462616,u*.560747,i*.5,u*.560747);c.bezierCurveTo(i*.537383,u*.560747,i*.794392,u*.560747,i*.915887,u*.509345);c.bezierCurveTo(i*.915887,u*.2757,i*.738317,u*.084112,i*.5,u*.084112);c.bezierCurveTo(i*.261682,u*.084112,i*.084112,u*.2757,i*.084112,u*.509345);c.closePath();a=c.createLinearGradient(0,.093457*u,0,.556073*u);a.addColorStop(0,"rgba(255, 255, 255, 0.275)");a.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type4":c.beginPath();c.moveTo(i*.67757,u*.24299);c.bezierCurveTo(i*.771028,u*.308411,i*.822429,u*.411214,i*.813084,u*.528037);c.bezierCurveTo(i*.799065,u*.654205,i*.719626,u*.757009,i*.593457,u*.799065);c.bezierCurveTo(i*.485981,u*.831775,i*.369158,u*.808411,i*.285046,u*.728971);c.bezierCurveTo(i*.2757,u*.719626,i*.252336,u*.714953,i*.233644,u*.728971);c.bezierCurveTo(i*.214953,u*.747663,i*.219626,u*.771028,i*.228971,u*.7757);c.bezierCurveTo(i*.331775,u*.878504,i*.476635,u*.915887,i*.616822,u*.869158);c.bezierCurveTo(i*.771028,u*.822429,i*.873831,u*.691588,i*.88785,u*.53271);c.bezierCurveTo(i*.897196,u*.38785,i*.836448,u*.257009,i*.719626,u*.182242);c.bezierCurveTo(i*.705607,u*.172897,i*.682242,u*.163551,i*.663551,u*.186915);c.bezierCurveTo(i*.654205,u*.205607,i*.668224,u*.238317,i*.67757,u*.24299);c.closePath();a=c.createRadialGradient(.5*i,.5*u,0,.5*i,.5*u,.38785*i);a.addColorStop(0,"rgba(255, 255, 255, 0)");a.addColorStop(.82,"rgba(255, 255, 255, 0)");a.addColorStop(.83,"rgba(255, 255, 255, 0)");a.addColorStop(1,"rgba(255, 255, 255, 0.15)");c.beginPath();c.moveTo(i*.261682,u*.224299);c.bezierCurveTo(i*.285046,u*.238317,i*.252336,u*.285046,i*.24299,u*.317757);c.bezierCurveTo(i*.24299,u*.350467,i*.271028,u*.383177,i*.271028,u*.397196);c.bezierCurveTo(i*.2757,u*.415887,i*.261682,u*.457943,i*.238317,u*.509345);c.bezierCurveTo(i*.224299,u*.542056,i*.17757,u*.612149,i*.158878,u*.612149);c.bezierCurveTo(i*.144859,u*.612149,i*.088785,u*.546728,i*.130841,u*.369158);c.bezierCurveTo(i*.140186,u*.336448,i*.214953,u*.200934,i*.261682,u*.224299);c.closePath();w=c.createLinearGradient(.130841*i,.369158*u,.273839*i,.412877*u);w.addColorStop(0,"rgba(255, 255, 255, 0.275)");w.addColorStop(1,"rgba(255, 255, 255, 0.015)");c.fillStyle=w;c.fill();break;case"type5":c.beginPath();c.moveTo(i*.084112,u*.5);c.bezierCurveTo(i*.084112,u*.271028,i*.271028,u*.084112,i*.5,u*.084112);c.bezierCurveTo(i*.700934,u*.084112,i*.864485,u*.224299,i*.906542,u*.411214);c.bezierCurveTo(i*.911214,u*.439252,i*.911214,u*.518691,i*.845794,u*.537383);c.bezierCurveTo(i*.794392,u*.546728,i*.551401,u*.411214,i*.392523,u*.457943);c.bezierCurveTo(i*.168224,u*.509345,i*.135514,u*.7757,i*.093457,u*.593457);c.bezierCurveTo(i*.088785,u*.560747,i*.084112,u*.53271,i*.084112,u*.5);c.closePath();a=c.createLinearGradient(0,.084112*u,0,.644859*u);a.addColorStop(0,"rgba(255, 255, 255, 0.275)");a.addColorStop(1,"rgba(255, 255, 255, 0.015)");break;case"type1":default:c.beginPath();c.moveTo(i*.084112,u*.509345);c.bezierCurveTo(i*.205607,u*.448598,i*.336448,u*.415887,i*.5,u*.415887);c.bezierCurveTo(i*.672897,u*.415887,i*.789719,u*.443925,i*.915887,u*.509345);c.bezierCurveTo(i*.915887,u*.2757,i*.738317,u*.084112,i*.5,u*.084112);c.bezierCurveTo(i*.261682,u*.084112,i*.084112,u*.2757,i*.084112,u*.509345);c.closePath();a=c.createLinearGradient(0,.088785*u,0,.490654*u);a.addColorStop(0,"rgba(255, 255, 255, 0.275)");a.addColorStop(1,"rgba(255, 255, 255, 0.015)")}c.fillStyle=a;c.fill();tt.cache[k]=b}return n.drawImage(tt.cache[k],0,0),this};tt.cache={};l=function(n,i,u){var h,f,o=n/2,s=n/2,e,c=n.toString()+i.type+u.style;if(!l.cache[c]){h=r(n*1.18889,n*1.18889);f=h.getContext("2d");switch(i.type){case"metalKnob":f.beginPath();f.moveTo(0,n*.5);f.bezierCurveTo(0,n*.222222,n*.222222,0,n*.5,0);f.bezierCurveTo(n*.777777,0,n,n*.222222,n,n*.5);f.bezierCurveTo(n,n*.777777,n*.777777,n,n*.5,n);f.bezierCurveTo(n*.222222,n,0,n*.777777,0,n*.5);f.closePath();e=f.createLinearGradient(0,0,0,n);e.addColorStop(0,"rgb(92, 95, 101)");e.addColorStop(.47,"rgb(46, 49, 53)");e.addColorStop(1,"rgb(22, 23, 26)");f.fillStyle=e;f.fill();f.beginPath();f.moveTo(n*.055555,n*.5);f.bezierCurveTo(n*.055555,n*.277777,n*.277777,n*.055555,n*.5,n*.055555);f.bezierCurveTo(n*.722222,n*.055555,n*.944444,n*.277777,n*.944444,n*.5);f.bezierCurveTo(n*.944444,n*.722222,n*.722222,n*.944444,n*.5,n*.944444);f.bezierCurveTo(n*.277777,n*.944444,n*.055555,n*.722222,n*.055555,n*.5);f.closePath();e=f.createLinearGradient(0,.055555*n,0,.944443*n);switch(u.style){case"black":e.addColorStop(0,"rgb(43, 42, 47)");e.addColorStop(1,"rgb(26, 27, 32)");break;case"brass":e.addColorStop(0,"rgb(150, 110, 54)");e.addColorStop(1,"rgb(124, 95, 61)");break;case"silver":default:e.addColorStop(0,"rgb(204, 204, 204)");e.addColorStop(1,"rgb(87, 92, 98)")}f.fillStyle=e;f.fill();f.beginPath();f.moveTo(n*.777777,n*.833333);f.bezierCurveTo(n*.722222,n*.722222,n*.611111,n*.666666,n*.5,n*.666666);f.bezierCurveTo(n*.388888,n*.666666,n*.277777,n*.722222,n*.222222,n*.833333);f.bezierCurveTo(n*.277777,n*.888888,n*.388888,n*.944444,n*.5,n*.944444);f.bezierCurveTo(n*.611111,n*.944444,n*.722222,n*.888888,n*.777777,n*.833333);f.closePath();e=f.createRadialGradient(.555555*n,.944444*n,0,.555555*n,.944444*n,.388888*n);e.addColorStop(0,"rgba(255, 255, 255, 0.6)");e.addColorStop(1,"rgba(255, 255, 255, 0)");f.fillStyle=e;f.fill();f.beginPath();f.moveTo(n*.944444,n*.277777);f.bezierCurveTo(n*.833333,n*.111111,n*.666666,0,n*.5,0);f.bezierCurveTo(n*.333333,0,n*.166666,n*.111111,n*.055555,n*.277777);f.bezierCurveTo(n*.166666,n*.333333,n*.333333,n*.388888,n*.5,n*.388888);f.bezierCurveTo(n*.666666,n*.388888,n*.833333,n*.333333,n*.944444,n*.277777);f.closePath();e=f.createRadialGradient(.5*n,0,0,.5*n,0,.583333*n);e.addColorStop(0,"rgba(255, 255, 255, 0.749019)");e.addColorStop(1,"rgba(255, 255, 255, 0)");f.fillStyle=e;f.fill();f.beginPath();f.moveTo(n*.277777,n*.555555);f.bezierCurveTo(n*.277777,n*.388888,n*.388888,n*.277777,n*.5,n*.277777);f.bezierCurveTo(n*.611111,n*.277777,n*.777777,n*.388888,n*.777777,n*.555555);f.bezierCurveTo(n*.777777,n*.666666,n*.611111,n*.777777,n*.5,n*.777777);f.bezierCurveTo(n*.388888,n*.777777,n*.277777,n*.666666,n*.277777,n*.555555);f.closePath();e=f.createLinearGradient(0,.277777*n,0,.722221*n);e.addColorStop(0,"#000000");e.addColorStop(1,"rgb(204, 204, 204)");f.fillStyle=e;f.fill();f.beginPath();f.moveTo(n*.333333,n*.555555);f.bezierCurveTo(n*.333333,n*.444444,n*.388888,n*.333333,n*.5,n*.333333);f.bezierCurveTo(n*.611111,n*.333333,n*.722222,n*.444444,n*.722222,n*.555555);f.bezierCurveTo(n*.722222,n*.611111,n*.611111,n*.722222,n*.5,n*.722222);f.bezierCurveTo(n*.388888,n*.722222,n*.333333,n*.611111,n*.333333,n*.555555);f.closePath();e=f.createLinearGradient(0,.333333*n,0,.666666*n);e.addColorStop(0,"rgb(10, 9, 1)");e.addColorStop(1,"rgb(42, 41, 37)");f.fillStyle=e;f.fill();break;case"standardKnob":e=f.createLinearGradient(0,0,0,n);e.addColorStop(0,"rgb(180, 180, 180)");e.addColorStop(.46,"rgb(63, 63, 63)");e.addColorStop(1,"rgb(40, 40, 40)");f.fillStyle=e;f.beginPath();f.arc(o,s,n/2,0,t,!0);f.closePath();f.fill();e=f.createLinearGradient(0,n-n*.77,0,n-n*.77+n*.77);switch(u.style){case"black":e.addColorStop(0,"rgb(191, 191, 191)");e.addColorStop(.5,"rgb(45, 44, 49)");e.addColorStop(1,"rgb(125, 126, 128)");break;case"brass":e.addColorStop(0,"rgb(223, 208, 174)");e.addColorStop(.5,"rgb(123, 95, 63)");e.addColorStop(1,"rgb(207, 190, 157)");break;case"silver":default:e.addColorStop(0,"rgb(215, 215, 215)");e.addColorStop(.5,"rgb(116, 116, 116)");e.addColorStop(1,"rgb(215, 215, 215)")}f.fillStyle=e;f.beginPath();f.arc(o,s,n*.77/2,0,t,!0);f.closePath();f.fill();e=f.createRadialGradient(o,s,0,o,s,n*.77/2);e.addColorStop(0,"rgba(0, 0, 0, 0)");e.addColorStop(.75,"rgba(0, 0, 0, 0)");e.addColorStop(.76,"rgba(0, 0, 0, 0.01)");e.addColorStop(1,"rgba(0, 0, 0, 0.2)");f.fillStyle=e;f.beginPath();f.arc(o,s,n*.77/2,0,t,!0);f.closePath();f.fill()}l.cache[c]=h}return l.cache[c]};l.cache={};a=function(n,i,f){var c,e,s=n/2,h=n/2,o,l=n.toString()+i+f.outerColor_ON;if(!a.cache[l]){c=r(n,n);e=c.getContext("2d");switch(i){case 0:o=e.createRadialGradient(s,h,0,s,h,n*.5/2);o.addColorStop(0,f.innerColor1_OFF);o.addColorStop(.2,f.innerColor2_OFF);o.addColorStop(1,f.outerColor_OFF);e.fillStyle=o;e.beginPath();e.arc(s,h,n*.5/2,0,t,!0);e.closePath();e.fill();o=e.createRadialGradient(s,h,0,s,h,n*.5/2);o.addColorStop(0,"rgba(0, 0, 0, 0)");o.addColorStop(.8,"rgba(0, 0, 0, 0)");o.addColorStop(1,"rgba(0, 0, 0, 0.4)");e.fillStyle=o;e.beginPath();e.arc(s,h,n*.5/2,0,t,!0);e.closePath();e.fill();o=e.createLinearGradient(0,.35*n,0,.35*n+.15*n);o.addColorStop(0,"rgba(255, 255, 255, 0.4)");o.addColorStop(1,"rgba(255, 255, 255, 0)");e.fillStyle=o;e.beginPath();e.arc(s,.35*n+.2*n/2,n*.2,0,t,!0);e.closePath();e.fill();break;case 1:o=e.createRadialGradient(s,h,0,s,h,n*.5/2);o.addColorStop(0,f.innerColor1_ON);o.addColorStop(.2,f.innerColor2_ON);o.addColorStop(1,f.outerColor_ON);e.fillStyle=o;e.beginPath();e.arc(s,h,n*.5/2,0,t,!0);e.closePath();e.fill();o=e.createRadialGradient(s,h,0,s,h,n*.5/2);o.addColorStop(0,"rgba(0, 0, 0, 0)");o.addColorStop(.8,"rgba(0, 0, 0, 0)");o.addColorStop(1,"rgba(0, 0, 0, 0.4)");e.fillStyle=o;e.beginPath();e.arc(s,h,n*.5/2,0,t,!0);e.closePath();e.fill();o=e.createLinearGradient(0,.35*n,0,.35*n+.15*n);o.addColorStop(0,"rgba(255, 255, 255, 0.4)");o.addColorStop(1,"rgba(255, 255, 255, 0)");e.fillStyle=o;e.beginPath();e.arc(s,.35*n+.2*n/2,n*.2,0,t,!0);e.closePath();e.fill();o=e.createRadialGradient(s,h,0,s,h,n/2);o.addColorStop(0,u(f.coronaColor,0));o.addColorStop(.6,u(f.coronaColor,.4));o.addColorStop(.7,u(f.coronaColor,.25));o.addColorStop(.8,u(f.coronaColor,.15));o.addColorStop(.85,u(f.coronaColor,.05));o.addColorStop(1,u(f.coronaColor,0));e.fillStyle=o;e.beginPath();e.arc(s,h,n/2,0,t,!0);e.closePath();e.fill()}a.cache[l]=c}return a.cache[l]};a.cache={};it=function(n,t,i){var e,f,o=0,v=n,c=t,l=Math.min(n,t)*.095,u,s=1,y=n-2,a=t-2,p=l-1,h=n.toString()+t+JSON.stringify(i);return it.cache[h]||(e=r(n,t),f=e.getContext("2d"),u=f.createLinearGradient(0,o,0,o+c),u.addColorStop(0,"#4c4c4c"),u.addColorStop(.08,"#666666"),u.addColorStop(.92,"#666666"),u.addColorStop(1,"#e6e6e6"),f.fillStyle=u,dt(f,0,o,v,c,l),f.fill(),u=f.createLinearGradient(0,s,0,s+a),u.addColorStop(0,i.gradientStartColor),u.addColorStop(.03,i.gradientFraction1Color),u.addColorStop(.49,i.gradientFraction2Color),u.addColorStop(.5,i.gradientFraction3Color),u.addColorStop(1,i.gradientStopColor),f.fillStyle=u,dt(f,1,s,y,a,p),f.fill(),it.cache[h]=e),it.cache[h]};it.cache={};et=function(n,t,i,r){var f,u,e=n.toString()+t+i+r;return et.cache[e]||(f=d.createElement("canvas"),u=f.getContext("2d"),f.width=n,f.height=n,u.fillStyle=t,i?(u.beginPath(),u.moveTo(n*.5,n),u.lineTo(0,0),u.lineTo(n,0),u.closePath(),u.fill()):r?(u.beginPath(),u.moveTo(n,n*.5),u.lineTo(0,0),u.lineTo(0,n),u.closePath(),u.fill()):(u.beginPath(),u.moveTo(n*.5,0),u.lineTo(n,n),u.lineTo(0,n),u.closePath(),u.fill()),et.cache[e]=f),et.cache[e]};et.cache={};w=function(n,i,f){var o=n*2,h,e,s,c=i.state+n+JSON.stringify(f),l=function(){var r=f[0];i.state==="up"?(s=e.createRadialGradient(.5*n,.2*o,0,.5*n,.2*o,.5*n),s.addColorStop(0,r.innerColor1_ON),s.addColorStop(.2,r.innerColor2_ON),s.addColorStop(1,r.outerColor_ON)):(s=e.createLinearGradient(0,0,0,.5*o),s.addColorStop(0,"#323232"),s.addColorStop(1,"#5c5c5c"));e.fillStyle=s;e.beginPath();e.moveTo(.5*n,0);e.lineTo(n,.2*o);e.lineTo(.752*n,.2*o);e.lineTo(.752*n,.37*o);e.lineTo(.252*n,.37*o);e.lineTo(.252*n,.2*o);e.lineTo(0,.2*o);e.closePath();e.fill();i.state!=="up"?(e.strokeStyle="rgba(0, 0, 0, 0.4)",e.beginPath(),e.moveTo(0,.2*o),e.lineTo(.5*n,0),e.lineTo(n,.2*o),e.moveTo(.252*n,.2*o),e.lineTo(.252*n,.37*o),e.stroke(),e.strokeStyle="rgba(255, 255, 255, 0.3)",e.beginPath(),e.moveTo(.252*n,.37*o),e.lineTo(.752*n,.37*o),e.lineTo(.752*n,.2*o),e.lineTo(n,.2*o),e.stroke()):(s=e.createRadialGradient(.5*n,.2*o,0,.5*n,.2*o,.7*n),s.addColorStop(0,u(r.coronaColor,0)),s.addColorStop(.5,u(r.coronaColor,.3)),s.addColorStop(.7,u(r.coronaColor,.2)),s.addColorStop(.8,u(r.coronaColor,.1)),s.addColorStop(.85,u(r.coronaColor,.05)),s.addColorStop(1,u(r.coronaColor,0)),e.fillStyle=s,e.beginPath(),e.arc(.5*n,.2*o,.7*n,0,t,!0),e.closePath(),e.fill())},a=function(){var r=f[1];e.beginPath();i.state==="steady"?(s=r.outerColor_ON,e.fillStyle=s,e.rect(.128*n,.41*o,.744*n,.074*o),e.rect(.128*n,.516*o,.744*n,.074*o),e.closePath(),e.fill()):(s=e.createLinearGradient(0,.41*o,0,.41*o+.074*o),s.addColorStop(0,"#323232"),s.addColorStop(1,"#5c5c5c"),e.fillStyle=s,e.rect(.128*n,.41*o,.744*n,.074*o),e.closePath(),e.fill(),s=e.createLinearGradient(0,.516*o,0,.516*o+.074*o),s.addColorStop(0,"#323232"),s.addColorStop(1,"#5c5c5c"),e.fillStyle=s,e.rect(.128*n,.516*o,.744*n,.074*o),e.closePath(),e.fill());i.state!=="steady"?(e.strokeStyle="rgba(0, 0, 0, 0.4)",e.beginPath(),e.moveTo(.128*n,.41*o+.074*o),e.lineTo(.128*n,.41*o),e.lineTo(.128*n+.744*n,.41*o),e.stroke(),e.beginPath(),e.moveTo(.128*n,.516*o+.074*o),e.lineTo(.128*n,.516*o),e.lineTo(.128*n+.744*n,.516*o),e.stroke(),e.strokeStyle="rgba(255, 255, 255, 0.3)",e.beginPath(),e.moveTo(.128*n+.744*n,.41*o),e.lineTo(.128*n+.744*n,.41*o+.074*o),e.lineTo(.128*n,.41*o+.074*o),e.stroke(),e.beginPath(),e.moveTo(.128*n+.744*n,.516*o),e.lineTo(.128*n+.744*n,.516*o+.074*o),e.lineTo(.128*n,.516*o+.074*o),e.stroke()):(s=e.createRadialGradient(.5*n,.5*o,0,.5*n,.5*o,.7*n),s.addColorStop(0,u(r.coronaColor,0)),s.addColorStop(.5,u(r.coronaColor,.3)),s.addColorStop(.7,u(r.coronaColor,.2)),s.addColorStop(.8,u(r.coronaColor,.1)),s.addColorStop(.85,u(r.coronaColor,.05)),s.addColorStop(1,u(r.coronaColor,0)),e.fillStyle=s,e.beginPath(),e.arc(.5*n,.5*o,.7*n,0,t,!0),e.closePath(),e.fill())},v=function(){var r=f[2];i.state==="down"?(s=e.createRadialGradient(.5*n,.8*o,0,.5*n,.8*o,.5*n),s.addColorStop(0,r.innerColor1_ON),s.addColorStop(.2,r.innerColor2_ON),s.addColorStop(1,r.outerColor_ON)):(s=e.createLinearGradient(0,.63*o,0,o),s.addColorStop(0,"#323232"),s.addColorStop(1,"#5c5c5c"));e.beginPath();e.fillStyle=s;e.moveTo(.5*n,o);e.lineTo(n,.8*o);e.lineTo(.725*n,.8*o);e.lineTo(.725*n,.63*o);e.lineTo(.252*n,.63*o);e.lineTo(.252*n,.8*o);e.lineTo(0,.8*o);e.closePath();e.fill();i.state!=="down"?(e.strokeStyle="rgba(0, 0, 0, 0.4)",e.beginPath(),e.moveTo(0,.8*o),e.lineTo(.252*n,.8*o),e.moveTo(.252*n,.63*o),e.lineTo(.752*n,.63*o),e.stroke(),e.beginPath(),e.moveTo(.752*n,.8*o),e.lineTo(n,.8*o),e.stroke(),e.strokeStyle="rgba(255, 255, 255, 0.3)",e.beginPath(),e.moveTo(0,.8*o),e.lineTo(.5*n,o),e.lineTo(n,.8*o),e.stroke(),e.beginPath(),e.moveTo(.752*n,.8*o),e.lineTo(.752*n,.63*o),e.stroke()):(s=e.createRadialGradient(.5*n,.8*o,0,.5*n,.8*o,.7*n),s.addColorStop(0,u(r.coronaColor,0)),s.addColorStop(.5,u(r.coronaColor,.3)),s.addColorStop(.7,u(r.coronaColor,.2)),s.addColorStop(.8,u(r.coronaColor,.1)),s.addColorStop(.85,u(r.coronaColor,.05)),s.addColorStop(1,u(r.coronaColor,0)),e.fillStyle=s,e.beginPath(),e.arc(.5*n,.8*o,.7*n,0,t,!0),e.closePath(),e.fill())};if(!w.cache[c]){h=r(n*2,n*4);e=h.getContext("2d");e.translate(n*.5,n*.5);switch(i.state){case"up":v();a();l();break;case"steady":v();l();a();break;case"down":default:l();a();v()}w.cache[c]=h}return w.cache[c]};w.cache={};var fi=function(n,t,i,r,u,f,e,o,h,c){c=undefined===c?c=steelseries.GaugeType.TYPE1:c;n.save();n.textAlign=o?"center":"left";n.textBaseline="middle";n.strokeStyle=f.labelColor.getRgbaColor();n.fillStyle=f.labelColor.getRgbaColor();o?(n.font=.046728*t+"px "+s,n.fillText(r,t/2,i*.3,t*.3),n.fillText(u,t/2,i*.38,t*.3)):e?(n.font=.1*t+"px "+s,n.save(),n.translate(.671428*t,.1375*i),n.rotate(1.570796),n.fillText(r,0,0),n.translate(-.671428*t,-.1375*i),n.restore(),n.font=.071428*t+"px "+s,h?c.type==="type2"?(n.textAlign="right",n.fillText(u,.36*t,i*.79,t*.25)):n.fillText(u,.63*t,i*.85,t*.2):(n.textAlign="center",c.type==="type2"?n.fillText(u,t/2,i*.92,t*.2):n.fillText(u,t/2,i*.89,t*.2))):(n.font=.035*t+"px "+s,n.fillText(r,t*.15,i*.25,t*.3),n.font=.025*t+"px "+s,n.fillText(u,t*.0625,i*.7,t*.07));n.restore()},wi=ii(12,12,function(n){var u=n.canvas.width,t=n.canvas.height,f=0,r=0,i;n.save();n.save();n.beginPath();n.rect(0,0,u*.5,t*.5);n.closePath();n.restore();i=n.createLinearGradient(0,r*t,0,.5*t+r*t);i.addColorStop(0,"rgb(35, 35, 35)");i.addColorStop(1,"rgb(23, 23, 23)");n.fillStyle=i;n.fill();n.save();n.beginPath();n.rect(u*.083333,0,u*.333333,t*.416666);n.closePath();n.restore();f=.083333;r=0;i=n.createLinearGradient(0,r*t,0,.416666*t+r*t);i.addColorStop(0,"rgb(38, 38, 38)");i.addColorStop(1,"rgb(30, 30, 30)");n.fillStyle=i;n.fill();n.save();n.beginPath();n.rect(u*.5,t*.5,u*.5,t*.5);n.closePath();n.restore();f=.5;r=.5;i=n.createLinearGradient(0,r*t,0,.5*t+r*t);i.addColorStop(0,"rgb(35, 35, 35)");i.addColorStop(1,"rgb(23, 23, 23)");n.fillStyle=i;n.fill();n.save();n.beginPath();n.rect(u*.583333,t*.5,u*.333333,t*.416666);n.closePath();n.restore();f=.583333;r=.5;i=n.createLinearGradient(0,r*t,0,.416666*t+r*t);i.addColorStop(0,"rgb(38, 38, 38)");i.addColorStop(1,"rgb(30, 30, 30)");n.fillStyle=i;n.fill();n.save();n.beginPath();n.rect(u*.5,0,u*.5,t*.5);n.closePath();n.restore();f=.5;r=0;i=n.createLinearGradient(0,r*t,0,.5*t+r*t);i.addColorStop(0,"#303030");i.addColorStop(1,"rgb(40, 40, 40)");n.fillStyle=i;n.fill();n.save();n.beginPath();n.rect(u*.583333,t*.083333,u*.333333,t*.416666);n.closePath();n.restore();f=.583333;r=.083333;i=n.createLinearGradient(0,r*t,0,.416666*t+r*t);i.addColorStop(0,"rgb(53, 53, 53)");i.addColorStop(1,"rgb(45, 45, 45)");n.fillStyle=i;n.fill();n.save();n.beginPath();n.rect(0,t*.5,u*.5,t*.5);n.closePath();n.restore();f=0;r=.5;i=n.createLinearGradient(0,r*t,0,.5*t+r*t);i.addColorStop(0,"#303030");i.addColorStop(1,"#282828");n.fillStyle=i;n.fill();n.save();n.beginPath();n.rect(u*.083333,t*.583333,u*.333333,t*.416666);n.closePath();n.restore();f=.083333;r=.583333;i=n.createLinearGradient(0,r*t,0,.416666*t+r*t);i.addColorStop(0,"#353535");i.addColorStop(1,"#2d2d2d");n.fillStyle=i;n.fill();n.restore()}),bi=ii(15,15,function(n){var i=n.canvas.width,t=n.canvas.height,r;n.save();n.save();n.beginPath();n.rect(0,0,i,t);n.closePath();n.restore();n.fillStyle="#1D2123";n.fill();n.save();n.beginPath();n.moveTo(0,t*.266666);n.bezierCurveTo(0,t*.4,i*.066666,t*.466666,i*.2,t*.466666);n.bezierCurveTo(i*.333333,t*.466666,i*.4,t*.4,i*.4,t*.266666);n.bezierCurveTo(i*.4,t*.133333,i*.333333,t*.066666,i*.2,t*.066666);n.bezierCurveTo(i*.066666,t*.066666,0,t*.133333,0,t*.266666);n.closePath();r=n.createLinearGradient(0,.066666*t,0,.466666*t);r.addColorStop(0,"#000000");r.addColorStop(1,"#444444");n.fillStyle=r;n.fill();n.save();n.beginPath();n.moveTo(0,t*.2);n.bezierCurveTo(0,t*.333333,i*.066666,t*.4,i*.2,t*.4);n.bezierCurveTo(i*.333333,t*.4,i*.4,t*.333333,i*.4,t*.2);n.bezierCurveTo(i*.4,t*.066666,i*.333333,0,i*.2,0);n.bezierCurveTo(i*.066666,0,0,t*.066666,0,t*.2);n.closePath();n.fillStyle="#050506";n.fill();n.save();n.beginPath();n.moveTo(i*.466666,t*.733333);n.bezierCurveTo(i*.466666,t*.866666,i*.533333,t*.933333,i*.666666,t*.933333);n.bezierCurveTo(i*.8,t*.933333,i*.866666,t*.866666,i*.866666,t*.733333);n.bezierCurveTo(i*.866666,t*.6,i*.8,t*.533333,i*.666666,t*.533333);n.bezierCurveTo(i*.533333,t*.533333,i*.466666,t*.6,i*.466666,t*.733333);n.closePath();r=n.createLinearGradient(0,.533333*t,0,.933333*t);r.addColorStop(0,"#000000");r.addColorStop(1,"#444444");n.fillStyle=r;n.fill();n.save();n.beginPath();n.moveTo(i*.466666,t*.666666);n.bezierCurveTo(i*.466666,t*.8,i*.533333,t*.866666,i*.666666,t*.866666);n.bezierCurveTo(i*.8,t*.866666,i*.866666,t*.8,i*.866666,t*.666666);n.bezierCurveTo(i*.866666,t*.533333,i*.8,t*.466666,i*.666666,t*.466666);n.bezierCurveTo(i*.533333,t*.466666,i*.466666,t*.533333,i*.466666,t*.666666);n.closePath();n.fillStyle="#050506";n.fill();n.restore()}),ki=function(n,t,i,u,f){function e(n,t){return n+=(2*Math.random()-1)*t|0,n<0?0:n>255?255:n}function s(n){return n<0?0:n>255?255:n}function h(n,t,i,r,u,f){var o,v,e,a,s,h,c,l;for(u>=i&&(u=i-1),a=1/(u*2+1),s=0,v=0;v<r;v++){for(h=c=l=0,o=0;o<u;o++)e=(s+o)*4,h+=n.data[e],c+=n.data[e+1],l+=n.data[e+2];for(o=0;o<i;o++)o>u&&(e=(s-u-1)*4,h-=n.data[e],c-=n.data[e+1],l-=n.data[e+2]),o+u<i&&(e=(s+u)*4,h+=n.data[e],c+=n.data[e+1],l+=n.data[e+2]),e=s*4,t.data[e]=h*a|0,t.data[e+1]=c*a|0,t.data[e+2]=l*a|0,t.data[e+3]=f,s++}}return this.fill=function(c,l,a,v){var k,d,nt,ot,p,b,st,g,y,ht,ct=255,lt=n>>16&255,at=n>>8&255,vt=n&255,tt=0,it=255*i,yt,pt,wt,w,rt,ut,ft,et;if(c=Math.floor(c),l=Math.floor(l),a=Math.ceil(a),v=Math.ceil(v),p=a-c,b=v-l,st=r(p,b),g=st.getContext("2d"),y=g.createImageData(p,b),ht=g.createImageData(p,b),f!==0)for(ot=[],k=0;k<p;k++)ot[k]=255*f*Math.sin(k/p*o)|0;for(nt=0;nt<b;nt++)for(t!==0&&(yt=pt=wt=0),d=0;d<p;d++)w=nt*p*4+d*4,rt=lt,ut=at,ft=vt,f!==0&&(et=ot[d],rt+=et,ut+=et,ft+=et),u?(tt=(2*Math.random()-1)*it|0,y.data[w]=s(rt+tt),y.data[w+1]=s(ut+tt),y.data[w+2]=s(ft+tt),y.data[w+3]=ct):(y.data[w]=e(rt,it),y.data[w+1]=e(ut,it),y.data[w+2]=e(ft,it),y.data[w+3]=ct);return t>0?(h(y,ht,p,b,t,ct),g.putImageData(ht,c,l)):g.putImageData(y,c,l),st},this},n=function(n,t,i,r){function s(){u=p(n,255);f=p(t,255);e=p(i,255);o=p(r,1)}var u,f,e,o;arguments.length===1?(i=parseInt(n.substr(5,2),16),t=parseInt(n.substr(3,2),16),n=parseInt(n.substr(1,2),16),r=1):arguments.length===3&&(r=1);s();this.getRed=function(){return u};this.setRed=function(n){u=p(n,255)};this.getGreen=function(){return f};this.setGreen=function(n){f=p(n,255)};this.getBlue=function(){return e};this.setBlue=function(n){e=p(n,255)};this.getAlpha=function(){return o};this.setAlpha=function(n){o=p(n,1)};this.getRgbaColor=function(){return"rgba("+u+", "+f+", "+e+", "+o+")"};this.getRgbColor=function(){return"rgb("+u+", "+f+", "+e+")"};this.getHexColor=function(){return"#"+u.toString(16)+f.toString(16)+e.toString(16)}},at=function(n,i){for(var f=n.length-1,u=0;u<=f;u++)n[u]=t*n[u]-o;this.fillCircle=function(t,e,o,s,h){var w,l=Math.ceil(h),c=l*2,a,tt,v,y,b,k,it,g,p,d,nt,rt;for(a=t.createImageData(c,c),tt=255,y=0;y<c;y++)for(k=l-y,it=k*k,v=0;v<c;v++)if(b=v-l,g=Math.sqrt(b*b+it),g<=l&&g>=s){for(w=Math.atan2(b,k),u=0;u<f;u++)w>=n[u]&&w<n[u+1]&&(d=kt(i[u],i[u+1],n[u+1]-n[u],w-n[u],!0));p=(c-y)*c*4+v*4;a.data[p]=d[0];a.data[p+1]=d[1];a.data[p+2]=d[2];a.data[p+3]=tt}nt=r(c,c);rt=nt.getContext("2d");rt.putImageData(a,0,0);t.drawImage(nt,e-l,o-l)};this.fillRect=function(t,e,o,s,h,c,l){var w,k,d,y,nt,a,v,tt,it,p,b,g,rt;for(s=Math.ceil(s),h=Math.ceil(h),k=s/2,d=h/2,c=Math.ceil(c),l=Math.ceil(l),y=t.createImageData(s,h),nt=255,v=0;v<h;v++)for(it=d-v,a=0;a<s;a++){for(v>l&&v<=h-l&&a>c&&a<s-c&&(a=s-c),tt=a-k,w=Math.atan2(tt,it),u=0;u<f;u++)w>=n[u]&&w<n[u+1]&&(b=kt(i[u],i[u+1],n[u+1]-n[u],w-n[u],!0));p=(h-v)*s*4+a*4;y.data[p]=b[0];y.data[p+1]=b[0];y.data[p+2]=b[0];y.data[p+3]=nt}g=r(s,h);rt=g.getContext("2d");rt.putImageData(y,0,0);t.drawImage(g,e-k,o-d)}},di=function(n,t,i,r){this.getColorAt=function(n){var u=0,e=0,f=1,o=1,t,s;for(n=n<0?0:n>1?1:n,t=0;t<i.length;t++){if(i[t]<n&&u<i[t]&&(u=i[t],e=t),i[t]===n)return r[t];i[t]>n&&f>=i[t]&&(f=i[t],o=t)}return s=(n-u)/(f-u),kt(r[e],r[o],1,s)};this.getStart=function(){return n};this.getEnd=function(){return t}},u=function(n,t){var i="#"===n.charAt(0)?n.substring(1,7):n,r=parseInt(i.substring(0,2),16),u=parseInt(i.substring(2,4),16),f=parseInt(i.substring(4,6),16);return"rgba("+r+","+u+","+f+","+t+")"};Math.log10=function(n){return Math.log(n)/Math.LN10};v=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(n){window.setTimeout(n,1e3/16)}}(),function(){e=function(n,t,i,r,u,f){this.gradientStart=n;this.gradientFraction=t;this.gradientStop=i;this.labelColor=r;this.symbolColor=u;this.name=f}}(),function(){f=function(n,t,i,r,u,f){this.gradientStartColor=n;this.gradientFraction1Color=t;this.gradientFraction2Color=i;this.gradientFraction3Color=r;this.gradientStopColor=u;this.textColor=f}}(),function(){y=function(n,t,i,r,u,f){this.veryDark=n;this.dark=t;this.medium=i;this.light=r;this.lighter=u;this.veryLight=f}}(),function(){ut=function(n,t,i,r,u,f,e){this.innerColor1_ON=n;this.innerColor2_ON=t;this.outerColor_ON=i;this.coronaColor=r;this.innerColor1_OFF=u;this.innerColor2_OFF=f;this.outerColor_OFF=e}}(),function(){ct=function(n){this.type=n}}(),function(){vt=function(n){this.type=n}}(),function(){ui=function(n){this.type=n}}(),function(){gt=function(n){this.style=n}}(),function(){b=function(n){this.design=n}}(),function(){h=function(n){this.type=n}}(),function(){lt=function(n){this.type=n}}(),function(){ni=function(n){this.format=n}}(),function(){ti=function(n){this.type=n}}(),function(){yt=function(n){this.state=n}}();var tr={DARK_GRAY:new e(new n(0,0,0,1),new n(51,51,51,1),new n(153,153,153,1),new n(255,255,255,1),new n(180,180,180,1),"DARK_GRAY"),SATIN_GRAY:new e(new n(45,57,57,1),new n(45,57,57,1),new n(45,57,57,1),new n(167,184,180,1),new n(137,154,150,1),"SATIN_GRAY"),LIGHT_GRAY:new e(new n(130,130,130,1),new n(181,181,181,1),new n(253,253,253,1),new n(0,0,0,1),new n(80,80,80,1),"LIGHT_GRAY"),WHITE:new e(new n(255,255,255,1),new n(255,255,255,1),new n(255,255,255,1),new n(0,0,0,1),new n(80,80,80,1),"WHITE"),BLACK:new e(new n(0,0,0,1),new n(0,0,0,1),new n(0,0,0,1),new n(255,255,255,1),new n(150,150,150,1),"BLACK"),BEIGE:new e(new n(178,172,150,1),new n(204,205,184,1),new n(231,231,214,1),new n(0,0,0,1),new n(80,80,80,1),"BEIGE"),BROWN:new e(new n(245,225,193,1),new n(245,225,193,1),new n(255,250,240,1),new n(109,73,47,1),new n(89,53,27,1),"BROWN"),RED:new e(new n(198,93,95,1),new n(212,132,134,1),new n(242,218,218,1),new n(0,0,0,1),new n(90,0,0,1),"RED"),GREEN:new e(new n(65,120,40,1),new n(129,171,95,1),new n(218,237,202,1),new n(0,0,0,1),new n(0,90,0,1),"GREEN"),BLUE:new e(new n(45,83,122,1),new n(115,144,170,1),new n(227,234,238,1),new n(0,0,0,1),new n(0,0,90,1),"BLUE"),ANTHRACITE:new e(new n(50,50,54,1),new n(47,47,51,1),new n(69,69,74,1),new n(250,250,250,1),new n(180,180,180,1),"ANTHRACITE"),MUD:new e(new n(80,86,82,1),new n(70,76,72,1),new n(57,62,58,1),new n(255,255,240,1),new n(225,225,210,1),"MUD"),PUNCHED_SHEET:new e(new n(50,50,54,1),new n(47,47,51,1),new n(69,69,74,1),new n(255,255,255,1),new n(180,180,180,1),"PUNCHED_SHEET"),CARBON:new e(new n(50,50,54,1),new n(47,47,51,1),new n(69,69,74,1),new n(255,255,255,1),new n(180,180,180,1),"CARBON"),STAINLESS:new e(new n(130,130,130,1),new n(181,181,181,1),new n(253,253,253,1),new n(0,0,0,1),new n(80,80,80,1),"STAINLESS"),BRUSHED_METAL:new e(new n(50,50,54,1),new n(47,47,51,1),new n(69,69,74,1),new n(0,0,0,1),new n(80,80,80,1),"BRUSHED_METAL"),BRUSHED_STAINLESS:new e(new n(50,50,54,1),new n(47,47,51,1),new n(110,110,112,1),new n(0,0,0,1),new n(80,80,80,1),"BRUSHED_STAINLESS"),TURNED:new e(new n(130,130,130,1),new n(181,181,181,1),new n(253,253,253,1),new n(0,0,0,1),new n(80,80,80,1),"TURNED")},ir={BEIGE:new f("#c8c8b1","rgb(241, 237, 207)","rgb(234, 230, 194)","rgb(225, 220, 183)","rgb(237, 232, 191)","#000000"),BLUE:new f("#ffffff","rgb(231, 246, 255)","rgb(170, 224, 255)","rgb(136, 212, 255)","rgb(192, 232, 255)","#124564"),ORANGE:new f("#ffffff","rgb(255, 245, 225)","rgb(255, 217, 147)","rgb(255, 201, 104)","rgb(255, 227, 173)","#503700"),RED:new f("#ffffff","rgb(255, 225, 225)","rgb(253, 152, 152)","rgb(252, 114, 115)","rgb(254, 178, 178)","#4f0c0e"),YELLOW:new f("#ffffff","rgb(245, 255, 186)","rgb(210, 255, 0)","rgb(158, 205, 0)","rgb(210, 255, 0)","#405300"),WHITE:new f("#ffffff","#ffffff","rgb(241, 246, 242)","rgb(229, 239, 244)","#ffffff","#000000"),GRAY:new f("#414141","rgb(117, 117, 117)","rgb(87, 87, 87)","#414141","rgb(81, 81, 81)","#ffffff"),BLACK:new f("#414141","#666666","#333333","#000000","#333333","#cccccc"),GREEN:new f("rgb(33, 67, 67)","rgb(33, 67, 67)","rgb(29, 58, 58)","rgb(28, 57, 57)","rgb(23, 46, 46)","rgba(0, 185, 165, 255)"),BLUE2:new f("rgb(0, 68, 103)","rgb(8, 109, 165)","rgb(0, 72, 117)","rgb(0, 72, 117)","rgb(0, 68, 103)","rgb(111, 182, 228)"),BLUE_BLACK:new f("rgb(22, 125, 212)","rgb(3, 162, 254)","rgb(3, 162, 254)","rgb(3, 162, 254)","rgb(11, 172, 244)","#000000"),BLUE_DARKBLUE:new f("rgb(18, 33, 88)","rgb(18, 33, 88)","rgb(19, 30, 90)","rgb(17, 31, 94)","rgb(21, 25, 90)","rgb(23, 99, 221)"),BLUE_GRAY:new f("rgb(135, 174, 255)","rgb(101, 159, 255)","rgb(44, 93, 255)","rgb(27, 65, 254)","rgb(12, 50, 255)","#b2b4ed"),STANDARD:new f("rgb(131, 133, 119)","rgb(176, 183, 167)","rgb(165, 174, 153)","rgb(166, 175, 156)","rgb(175, 184, 165)","rgb(35, 42, 52)"),STANDARD_GREEN:new f("#ffffff","rgb(219, 230, 220)","rgb(179, 194, 178)","rgb(153, 176, 151)","rgb(114, 138, 109)","#080C06"),BLUE_BLUE:new f("rgb(100, 168, 253)","rgb(100, 168, 253)","rgb(95, 160, 250)","rgb(80, 144, 252)","rgb(74, 134, 255)","#002cbb"),RED_DARKRED:new f("rgb(72, 36, 50)","rgb(185, 111, 110)","rgb(148, 66, 72)","rgb(83, 19, 20)","rgb(7, 6, 14)","#FE8B92"),DARKBLUE:new f("rgb(14, 24, 31)","rgb(46, 105, 144)","rgb(19, 64, 96)","rgb(6, 20, 29)","rgb(8, 9, 10)","#3DB3FF"),LILA:new f("rgb(175, 164, 255)","rgb(188, 168, 253)","rgb(176, 159, 255)","rgb(174, 147, 252)","rgb(168, 136, 233)","#076148"),BLACKRED:new f("rgb(8, 12, 11)","rgb(10, 11, 13)","rgb(11, 10, 15)","rgb(7, 13, 9)","rgb(9, 13, 14)","#B50026"),DARKGREEN:new f("rgb(25, 85, 0)","rgb(47, 154, 0)","rgb(30, 101, 0)","rgb(30, 101, 0)","rgb(25, 85, 0)","#233123"),AMBER:new f("rgb(182, 71, 0)","rgb(236, 155, 25)","rgb(212, 93, 5)","rgb(212, 93, 5)","rgb(182, 71, 0)","#593A0A"),LIGHTBLUE:new f("rgb(125, 146, 184)","rgb(197, 212, 231)","rgb(138, 155, 194)","rgb(138, 155, 194)","rgb(125, 146, 184)","#090051"),SECTIONS:new f("#b2b2b2","#ffffff","#c4c4c4","#c4c4c4","#b2b2b2","#000000")},rr={RED:new y(new n(82,0,0,1),new n(158,0,19,1),new n(213,0,25,1),new n(240,82,88,1),new n(255,171,173,1),new n(255,217,218,1)),GREEN:new y(new n(8,54,4,1),new n(0,107,14,1),new n(15,148,0,1),new n(121,186,37,1),new n(190,231,141,1),new n(234,247,218,1)),BLUE:new y(new n(0,11,68,1),new n(0,73,135,1),new n(0,108,201,1),new n(0,141,242,1),new n(122,200,255,1),new n(204,236,255,1)),ORANGE:new y(new n(118,83,30,1),new n(215,67,0,1),new n(240,117,0,1),new n(255,166,0,1),new n(255,255,128,1),new n(255,247,194,1)),YELLOW:new y(new n(41,41,0,1),new n(102,102,0,1),new n(177,165,0,1),new n(255,242,0,1),new n(255,250,153,1),new n(255,252,204,1)),CYAN:new y(new n(15,109,109,1),new n(0,109,144,1),new n(0,144,191,1),new n(0,174,239,1),new n(153,223,249,1),new n(204,239,252,1)),MAGENTA:new y(new n(98,0,114,1),new n(128,24,72,1),new n(191,36,107,1),new n(255,48,143,1),new n(255,172,210,1),new n(255,214,23,1)),WHITE:new y(new n(210,210,210,1),new n(220,220,220,1),new n(235,235,235,1),new n(255,255,255,1),new n(255,255,255,1),new n(255,255,255,1)),GRAY:new y(new n(25,25,25,1),new n(51,51,51,1),new n(76,76,76,1),new n(128,128,128,1),new n(204,204,204,1),new n(243,243,243,1)),BLACK:new y(new n(0,0,0,1),new n(5,5,5,1),new n(10,10,10,1),new n(15,15,15,1),new n(20,20,20,1),new n(25,25,25,1)),RAITH:new y(new n(0,32,65,1),new n(0,65,125,1),new n(0,106,172,1),new n(130,180,214,1),new n(148,203,242,1),new n(191,229,255,1)),GREEN_LCD:new y(new n(0,55,45,1),new n(15,109,93,1),new n(0,185,165,1),new n(48,255,204,1),new n(153,255,227,1),new n(204,255,241,1)),JUG_GREEN:new y(new n(0,56,0,1),new n(32,69,36,1),new n(50,161,0,1),new n(129,206,0,1),new n(190,231,141,1),new n(234,247,218,1))},ur={RED_LED:new ut("#FF9A89","#FF9A89","#FF3300","#FF8D70","#7E1C00","#7E1C00","#641B00"),GREEN_LED:new ut("#9AFF89","#9AFF89","#59FF2A","#A5FF00","#1C7E00","#1C7E00","#1B6400"),BLUE_LED:new ut("#899AFF","#899AFF","#0033FF","#708DFF","#001C7E","#001C7E","#001B64"),ORANGE_LED:new ut("#FEA23F","#FEA23F","#FD6C00","#FD6C00","#592800","#592800","#421F00"),YELLOW_LED:new ut("#FFFF62","#FFFF62","#FFFF00","#FFFF00","#6B6D00","#6B6D00","#515300"),CYAN_LED:new ut("#00FFFF","#00FFFF","#1BC3C3","#00FFFF","#083B3B","#083B3B","#052727"),MAGENTA_LED:new ut("#D300FF","#D300FF","#8600CB","#C300FF","#38004B","#38004B","#280035")},fr={TYPE1:new ct("type1"),TYPE2:new ct("type2"),TYPE3:new ct("type3"),TYPE4:new ct("type4"),TYPE5:new ct("type5")},er={NORTH:new vt("north"),SOUTH:new vt("south"),EAST:new vt("east"),WEST:new vt("west")},or={STANDARD_KNOB:new ui("standardKnob"),METAL_KNOB:new ui("metalKnob")},sr={BLACK:new gt("black"),BRASS:new gt("brass"),SILVER:new gt("silver")},hr={BLACK_METAL:new b("blackMetal"),METAL:new b("metal"),SHINY_METAL:new b("shinyMetal"),BRASS:new b("brass"),STEEL:new b("steel"),CHROME:new b("chrome"),GOLD:new b("gold"),ANTHRACITE:new b("anthracite"),TILTED_GRAY:new b("tiltedGray"),TILTED_BLACK:new b("tiltedBlack"),GLOSSY_METAL:new b("glossyMetal")},cr={TYPE1:new h("type1"),TYPE2:new h("type2"),TYPE3:new h("type3"),TYPE4:new h("type4"),TYPE5:new h("type5"),TYPE6:new h("type6"),TYPE7:new h("type7"),TYPE8:new h("type8"),TYPE9:new h("type9"),TYPE10:new h("type10"),TYPE11:new h("type11"),TYPE12:new h("type12"),TYPE13:new h("type13"),TYPE14:new h("type14"),TYPE15:new h("type15"),TYPE16:new h("type16")},lr={TYPE1:new lt("type1"),TYPE2:new lt("type2"),TYPE3:new lt("type3"),TYPE4:new lt("type4"),TYPE5:new lt("type5")},ar={STANDARD:new ni("standard"),FRACTIONAL:new ni("fractional"),SCIENTIFIC:new ni("scientific")},vr={NORMAL:new ti("normal"),HORIZONTAL:new ti("horizontal"),TANGENT:new ti("tangent")},yr={UP:new yt("up"),STEADY:new yt("steady"),DOWN:new yt("down"),OFF:new yt("off")};return{Radial:hi,RadialBargraph:ci,DisplaySingle:li,WindDirection:ai,Led:vi,Odometer:yi,drawFrame:g,drawBackground:nt,drawForeground:tt,rgbaColor:n,ConicalGradient:at,setAlpha:u,getColorFromFraction:kt,gradientWrapper:di,BackgroundColor:tr,LcdColor:ir,ColorDef:rr,LedColor:ur,GaugeType:fr,Orientation:er,FrameDesign:hr,PointerType:cr,ForegroundType:lr,KnobType:or,KnobStyle:sr,LabelNumberFormat:ar,TickLabelOrientation:vr,TrendState:yr,Section:gi}}()
/*!*********************************************************************
TERMS OF USE - EASING EQUATIONS
Open source under the BSD License.
Copyright (c) 2001 Robert Penner
JavaScript version copyright (C) 2006 by Philippe Maegerman
All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:
   * Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above
copyright notice, this list of conditions and the following disclaimer
in the documentation and/or other materials provided with the
distribution.
   * Neither the name of the author nor the names of contributors may
be used to endorse or promote products derived from this software
without specific prior written permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*****************************************/
function Delegate(){}Delegate.create=function(n,t){for(var r=[],u=arguments.length,i=2;i<u;i++)r[i-2]=arguments[i];return function(){var i=[].concat(arguments,r);t.apply(n,i)}};var Tween=function(n,t,i,r,u,f,e){this.init(n,t,i,r,u,f,e)},t=Tween.prototype;t.obj={},t.prop="",t.func=function(n,t,i,r){return i*n/r+t},t.begin=0,t.change=0,t.prevTime=0,t.prevPos=0,t.looping=!1,t._duration=0,t._time=0,t._pos=0,t._position=0,t._startTime=0,t._finish=0,t.name="",t.suffixe="",t._listeners=[],t.setTime=function(n){this.prevTime=this._time,n>this.getDuration()?this.looping?(this.rewind(n-this._duration),this.update(),this.broadcastMessage("onMotionLooped",{target:this,type:"onMotionLooped"})):(this._time=this._duration,this.update(),this.stop(),this.broadcastMessage("onMotionFinished",{target:this,type:"onMotionFinished"})):n<0?(this.rewind(),this.update()):(this._time=n,this.update())},t.getTime=function(){return this._time},t.setDuration=function(n){this._duration=n===null||n<=0?1e5:n},t.getDuration=function(){return this._duration},t.setPosition=function(n){this.prevPos=this._pos;var t=this.suffixe!==""?this.suffixe:"";this.obj[this.prop]=Math.round(n)+t,this._pos=n,this.broadcastMessage("onMotionChanged",{target:this,type:"onMotionChanged"})},t.getPosition=function(n){return n===undefined&&(n=this._time),this.func(n,this.begin,this.change,this._duration)},t.setFinish=function(n){this.change=n-this.begin},t.getFinish=function(){return this.begin+this.change},t.init=function(n,t,i,r,u,f,e){arguments.length&&(this._listeners=[],this.addListener(this),e&&(this.suffixe=e),this.obj=n,this.prop=t,this.begin=r,this._pos=r,this.setDuration(f),i!==null&&i!==""&&(this.func=i),this.setFinish(u))},t.start=function(){this.rewind(),this.startEnterFrame(),this.broadcastMessage("onMotionStarted",{target:this,type:"onMotionStarted"})},t.rewind=function(n){this.stop(),this._time=n===undefined?0:n,this.fixTime(),this.update()},t.fforward=function(){this._time=this._duration,this.fixTime(),this.update()},t.update=function(){this.setPosition(this.getPosition(this._time))},t.startEnterFrame=function(){this.stopEnterFrame(),this.isPlaying=!0,this.onEnterFrame()},t.onEnterFrame=function(){this.isPlaying&&(this.nextFrame(),setTimeout(Delegate.create(this,this.onEnterFrame),25))},t.nextFrame=function(){this.setTime((this.getTimer()-this._startTime)/1e3)},t.stop=function(){this.stopEnterFrame(),this.broadcastMessage("onMotionStopped",{target:this,type:"onMotionStopped"})},t.stopEnterFrame=function(){this.isPlaying=!1},t.playing=function(){return this.isPlaying},t.continueTo=function(n,t){this.begin=this._pos,this.setFinish(n),this._duration!==undefined&&this.setDuration(t),this.start()},t.resume=function(){this.fixTime(),this.startEnterFrame(),this.broadcastMessage("onMotionResumed",{target:this,type:"onMotionResumed"})},t.yoyo=function(){this.continueTo(this.begin,this._time)},t.addListener=function(n){return this.removeListener(n),this._listeners.push(n)},t.removeListener=function(n){for(var t=this._listeners,i=t.length;i--;)if(t[i]===n)return t.splice(i,1),!0;return!1},t.broadcastMessage=function(){for(var i=[],r,t=this._listeners,u=t.length,n=0;n<arguments.length;n++)i.push(arguments[n]);for(r=i.shift(),n=0;n<u;n++)t[n][r]&&t[n][r].apply(t[n],i)},t.fixTime=function(){this._startTime=this.getTimer()-this._time*1e3},t.getTimer=function(){return(new Date).getTime()-this._time},Tween.backEaseIn=function(n,t,i,r){var u=1.70158;return i*(n/=r)*n*((u+1)*n-u)+t},Tween.backEaseOut=function(n,t,i,r){var u=1.70158;return i*((n=n/r-1)*n*((u+1)*n+u)+1)+t},Tween.backEaseInOut=function(n,t,i,r){var u=1.70158;return(n/=r/2)<1?i/2*n*n*(((u*=1.525)+1)*n-u)+t:i/2*((n-=2)*n*(((u*=1.525)+1)*n+u)+2)+t},Tween.elasticEaseIn=function(n,t,i,r,u,f){var e;return n===0?t:(n/=r)==1?t+i:(f||(f=r*.3),!u||u<Math.abs(i)?(u=i,e=f/4):e=f/(2*Math.PI)*Math.asin(i/u),-(u*Math.pow(2,10*(n-=1))*Math.sin((n*r-e)*2*Math.PI/f))+t)},Tween.elasticEaseOut=function(n,t,i,r,u,f){var e;return n===0?t:(n/=r)==1?t+i:(f||(f=r*.3),!u||u<Math.abs(i)?(u=i,e=f/4):e=f/(2*Math.PI)*Math.asin(i/u),u*Math.pow(2,-10*n)*Math.sin((n*r-e)*2*Math.PI/f)+i+t)},Tween.elasticEaseInOut=function(n,t,i,r,u,f){var e;return n===0?t:(n/=r/2)==2?t+i:(f||(f=r*.3*1.5),!u||u<Math.abs(i)?(u=i,e=f/4):e=f/(2*Math.PI)*Math.asin(i/u),n<1)?-.5*u*Math.pow(2,10*(n-=1))*Math.sin((n*r-e)*2*Math.PI/f)+t:u*Math.pow(2,-10*(n-=1))*Math.sin((n*r-e)*2*Math.PI/f)*.5+i+t},Tween.bounceEaseOut=function(n,t,i,r){return(n/=r)<1/2.75?i*7.5625*n*n+t:n<2/2.75?i*(7.5625*(n-=1.5/2.75)*n+.75)+t:n<2.5/2.75?i*(7.5625*(n-=2.25/2.75)*n+.9375)+t:i*(7.5625*(n-=2.625/2.75)*n+.984375)+t},Tween.bounceEaseIn=function(n,t,i,r){return i-Tween.bounceEaseOut(r-n,0,i,r)+t},Tween.bounceEaseInOut=function(n,t,i,r){return n<r/2?Tween.bounceEaseIn(n*2,0,i,r)*.5+t:Tween.bounceEaseOut(n*2-r,0,i,r)*.5+i*.5+t},Tween.strongEaseInOut=function(n,t,i,r){return i*(n/=r)*n*n*n*n+t},Tween.regularEaseIn=function(n,t,i,r){return i*(n/=r)*n+t},Tween.regularEaseOut=function(n,t,i,r){return-i*(n/=r)*(n-2)+t},Tween.regularEaseInOut=function(n,t,i,r){return(n/=r/2)<1?i/2*n*n+t:-i/2*(--n*(n-2)-1)+t},Tween.strongEaseIn=function(n,t,i,r){return i*(n/=r)*n*n*n*n+t},Tween.strongEaseOut=function(n,t,i,r){return i*((n=n/r-1)*n*n*n*n+1)+t},Tween.strongEaseInOut=function(n,t,i,r){return(n/=r/2)<1?i/2*n*n*n*n*n+t:i/2*((n-=2)*n*n*n*n+2)+t}
