/*	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * 	Script:	Monthly Records Data    * 	File:	recordsmonthly.js
 * 	Role:	Collect and insert data into monthly records page.
 * 	Author:	Neil Thomas             * v:3.0.1
 * 	Edited: 22/12/2024
 * 	Checked:
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/

// Last modified: 2022/07/27 15:35:57

$(function() {

    dataLoadedPromise.then(function( response ) {
        removeBtns();
        $('.ax-btnBar').children('button').removeClass( 'ax-disabled');
    	var selected = CMXConfig.Records.Monthly;
	    if ( selected != null && selected != '' ) {
	        changeData( selected );
	        $('.ax-btnBar').children('button').removeClass('ax-disabled');
	        $('#btnMon' + selected).attr('aria-pressed', true).addClass('ax-disabled');
	    } else {
	        selected = new Date();
	        selected.setDate(selected.getDate() );
	        changeData( selected.getMonth() );
	        $('.ax-btnBar').children('button').removeClass('ax-disabled');
	        $('#btnMon' + selected.getMonth()).attr('aria-pressed', true).addClass('ax-disabled');
	    }
    });
});

let removeBtns = function() {
    console.log("Removing buttons");
    var beganDate = new Date(cmxData.recordsbegandate);
    var beganYear = beganDate.getFullYear();
    var beganMonth = beganDate.getMonth();
	var thisDate = new Date();
    var thisYear = thisDate.getFullYear();
    var thisMonth = thisDate.getMonth();
	if( beganYear == thisYear) {
		for ( var btn = 0; btn < (beganMonth ); btn++) {
			$('#btnMon' + btn).remove();
		}
		for (var btn = 11; btn > (thisMonth); btn--) {
			$('#btnMon' + btn).remove();
		}
    }
    
    if( beganYear == (thisYear - 1) && beganMonth > thisMonth) {
        console.log("Need to remove middle buttons:" + beganMonth + " - " + thisMonth)
        for (var btn = beganMonth - 1; btn > thisMonth; btn--) {
            $('#btnMon' + btn).remove();
        }
        //  Put a divider between month buttons
        var htmlX = '<span style="flex-grow:0;align-self:center;padding:0 3px;">';
        htmlX += '<i class="fa-solid fa-diamond ax-theme6-txt ax-small"></i></span>';
        $('#btnMon' + thisMonth).after(htmlX)
    }
};

var monthnames = new Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");

function changeData(month) {
    CMXConfig.Records.Monthly = month;
	sessionStorage.setItem(axStore, JSON.stringify(CMXConfig));
    
    $('[data-cmxData="MonthName"]').html(monthnames[month]);
    $('[data-cmxdata="TempH"]').html(cmxData.monthlyrecs.hightemp[month]);
    $('[data-cmxdata="TempHT"]').html(cmxData.monthlyrecs.hightempT[month]);

    $('[data-cmxdata="TempL"]').html(cmxData.monthlyrecs.lowtemp[month]);
    $('[data-cmxdata="TempLT"]').html(cmxData.monthlyrecs.lowtempT[month]);
    $('[data-cmxdata="DewPointH"]').html(cmxData.monthlyrecs.highDP[month]);
    $('[data-cmxdata="DewPointHT"]').html(cmxData.monthlyrecs.highDPT[month]);

    $("[data-cmxdata='DewPointL']").html(cmxData.monthlyrecs.lowDP[month]);
    $("[data-cmxdata='DewPointLT']").html(cmxData.monthlyrecs.lowDPT[month]);
    $("[data-cmxdata='AppTempH']").html(cmxData.monthlyrecs.highapptemp[month]);
    $("[data-cmxdata='AppTempHT']").html(cmxData.monthlyrecs.highapptempT[month]);
    $("[data-cmxdata='AppTempL']").html(cmxData.monthlyrecs.lowapptemp[month]);
    $("[data-cmxdata='AppTempLT']").html(cmxData.monthlyrecs.lowapptempT[month]);
    $("[data-cmxdata='FeelsLikeH']").html(cmxData.monthlyrecs.highfeelslike[month]);
    $("[data-cmxdata='FeelsLikeHT']").html(cmxData.monthlyrecs.highfeelslikeT[month]);
    $("[data-cmxdata='FeelsLikeL']").html(cmxData.monthlyrecs.lowfeelslike[month]);
    $("[data-cmxdata='FeelsLikeLT']").html(cmxData.monthlyrecs.lowfeelslikeT[month]);
    $("[data-cmxdata='WChillL']").html(cmxData.monthlyrecs.lowchill[month]);

    $("[data-cmxdata='WChillLT']").html(cmxData.monthlyrecs.lowchillT[month]);
    $("[data-cmxdata='HeatIndexH']").html(cmxData.monthlyrecs.highheatindex[month]);
    $("[data-cmxdata='HeatIndexHT']").html(cmxData.monthlyrecs.highheatindexT[month]);

    $("[data-cmxdata='MinTempH']").html(cmxData.monthlyrecs.highmintemp[month]);
    $("[data-cmxdata='MinTempHT']").html(cmxData.monthlyrecs.highmintempT[month]);

    $("[data-cmxdata='MaxTempL']").html(cmxData.monthlyrecs.lowmaxtemp[month]);
    $("[data-cmxdata='MaxTempLT']").html(cmxData.monthlyrecs.lowmaxtempT[month]);

    $("[data-cmxdata='HumH']").html(cmxData.monthlyrecs.highhum[month]);
    $("[data-cmxdata='HumHT']").html(cmxData.monthlyrecs.highhumT[month]);
    $("[data-cmxdata='HumL']").html(cmxData.monthlyrecs.lowhum[month]);
    $("[data-cmxdata='HumLT']").html(cmxData.monthlyrecs.lowhumT[month]);

    $("[data-cmxdata='HighDailyTempRange']").html(cmxData.monthlyrecs.hightemprange[month]);
    $("[data-cmxdata='HighDailyTempRangeT']").html(cmxData.monthlyrecs.hightemprangeT[month]);
    $("[data-cmxdata='LowDailyTempRange']").html(cmxData.monthlyrecs.lowtemprange[month]);
    $("[data-cmxdata='LowDailyTempRangeT']").html(cmxData.monthlyrecs.lowtemprangeT[month]);

    $("[data-cmxdata='RainRateH']").html(cmxData.monthlyrecs.rainrate[month]);
    $("[data-cmxdata='RainRateHT']").html(cmxData.monthlyrecs.rainrateT[month]);
    $("[data-cmxdata='HourlyRainH']").html(cmxData.monthlyrecs.hourlyrain[month]);
    $("[data-cmxdata='HourlyRainHT']").html(cmxData.monthlyrecs.hourlyrainT[month]);
    $("[data-cmxdata='Rain24HourH']").html(cmxData.monthlyrecs.rain24h[month]);
    $("[data-cmxdata='Rain24HourHT']").html(cmxData.monthlyrecs.rain24hT[month]);
    $("[data-cmxdata='DailyRainH']").html(cmxData.monthlyrecs.dailyrain[month]);
    $("[data-cmxdata='DailyRainHT']").html(cmxData.monthlyrecs.dailyrainT[month]);
    $("[data-cmxdata='MonthlyRainH']").html(cmxData.monthlyrecs.monthlyrain[month]);
    $("[data-cmxdata='MonthlyRainHT']").html(cmxData.monthlyrecs.monthlyrainT[month]);
    $("[data-cmxdata='LongestDryPeriod']").html(cmxData.monthlyrecs.dryperiod[month]);
    $("[data-cmxdata='LongestDryPeriodT']").html(cmxData.monthlyrecs.dryperiodT[month]);
    $("[data-cmxdata='LongestWetPeriod']").html(cmxData.monthlyrecs.wetperiod[month]);
    $("[data-cmxdata='LongestWetPeriodT']").html(cmxData.monthlyrecs.wetperiodT[month]);
    $("[data-cmxdata='GustH']").html(cmxData.monthlyrecs.highgust[month]);
    $("[data-cmxdata='GustHT']").html(cmxData.monthlyrecs.highgustT[month]);
    $("[data-cmxdata='WindH']").html(cmxData.monthlyrecs.highwind[month]);
    $("[data-cmxdata='WindHT']").html(cmxData.monthlyrecs.highwindT[month]);
    $("[data-cmxdata='WindRunH']").html(cmxData.monthlyrecs.highwindrun[month]);
    $("[data-cmxdata='WindRunHT']").html(cmxData.monthlyrecs.highwindrunT[month]);
    $("[data-cmxdata='PressL']").html(cmxData.monthlyrecs.lowpress[month]);
    $("[data-cmxdata='PressLT']").html(cmxData.monthlyrecs.lowpressT[month]);
    $("[data-cmxdata='PressH']").html(cmxData.monthlyrecs.highpress[month]);
    $("[data-cmxdata='PressHT']").html(cmxData.monthlyrecs.highpressT[month]);
    $('.ax-btnBar').children('button').attr("aria-pressed", false).removeClass('ax-ax-disabled');
    $('#btnMon' + month).attr('aria-pressed', true).addClass('ax-disabled');
}
