/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Script:   page-control.js     *         v:5.0.1
  Author:   Neil Thomas         *    October 2025
  Original: N Thomas 2024-08-01 10:00:00
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  Last Ed:  2025-10-04 10:49:36
  Role:   Provide all utility scripts & functions
  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

let cmxConfig = {}; // Holds Configuration values
let cmxData;        // Holds the data from the JSON file
let dataPath;       // Path to the data directory
let HTMLmenu = "";  //  Placeholder for menu(s)
let dataLoadedPromise;

let initialLoad = true;
let activePages = ['index', 'today', 'todayVyest', 'template1', 'template2'];
//  ~~~~    You can change these to suit your language.
let monthName = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
let dayName = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];   

//  Configure name for storage object
var temp = location.pathname;
var owsStore = temp.split('/');
owsStore.pop();
owsStore.shift();
owsStore = owsStore.join('-') + '-cmxConfig';  

let getConfig = function(store) {
    //  Check if we have a config object in local storage
    var storedCfg = sessionStorage.getItem(store);
    if (storedCfg == null) {
        //  No config object, so create a new one
        console.log("No configuration stored");
        cmxConfig = {
            Charts: {
                Trends: '',
                Historic: '',
            },
            Custom: {
                StandardMenu: false,
		        Dropdown: true,
	    	    Theme: '',
    	    	Logo: '',
		        BannerImage: '',
		        StaticHead: true,
		        StaticFoot: true,
		        PaddingTop: '2',
		        PaddingBottom: '1',
		        PaddingUnits: 'em',
            },
            Data: '',
            Menu: 'js/ows-menu.js',
            NOAAReportPath: 'Reports/',
            Gull: {
                Animation: '',
                Speed: 10,
                OnTop: false,
            },
            Records: {
                All: '',
                Monthly: '',
            }
        };
        //  And store it
        sessionStorage.setItem(store, JSON.stringify(cmxConfig));
    } else {
        cmxConfig = JSON.parse(storedCfg);
    }
}

let setTheme = function() {
    //  Set the theme based on the configuration
    if (cmxConfig.Custom.Theme != '') {
        console.log('Setting theme to: ' + cmxConfig.Theme);
        $('#theme').after('<link rel="stylesheet" href="css/themes/' + cmxConfig.Custom.Theme + '.css">');
    } else {
        console.log('No theme set, using default');
    }
}

getConfig( owsStore );
setTheme();

let setPage = function() {
    //  Set Logo
    switch( cmxConfig.Custom.Logo ) {
        case 'None':    // No logo required
            $('#siteLogo').css('visibility', 'hidden'); break;
        case '':        // Default logo required
            $('#siteLogo').attr('src', 'images/logo.png');  break;
        default:        // Custom logo
            $('#siteLogo').attr('src',cmxConfig.Custom.Logo);
            $('#siteLogo').attr('alt','User supplied logo')
    }
    //  Set banner image
    if( cmxConfig.Custom.BannerImage != '') {
        $('#siteHeader').css('background', 'url(' + cmxConfig.Custom.BannerImage + ') no-repeat center bottom');
        $('#siteHeader').removeClass('ows-theme5').addClass('ows-theme0');
    }
    //  Add colour to menu bar background
    $('.ows-menu').addClass( cmxConfig.Custom.StandardMenu ? 'ows-theme5' : '');
    //  Adjust page spacing
    var headHt = $('#siteHeader').outerHeight();
    var footHt = $('#siteFooter').outerHeight();
    //  Set the padding between header / footer and main content
    $('#siteContent_Inner').css('padding-top', cmxConfig.Custom.PaddingTop + cmxConfig.Custom.PaddingUnits );
    $('#menuSidebar').css('margin-top', -(cmxConfig.Custom.PaddingTop + cmxConfig.Custom.PaddingUnits));
    $('#siteContent_Inner').css('padding-bottom', cmxConfig.Custom.PaddingBottom + cmxConfig.Custom.PaddingUnits );
    //  Set the fixed/scroll status of the header
    if( cmxConfig.Custom.StaticHead ) {
        $('#siteHeader').addClass('w3-top');
        $('#siteContent').css('margin-top', headHt + 'px');
    }   else {
        $('#siteHeader').removeClass('w3-top');
        $('#siteContent').css('margin-top', 0);
    }
    //  Set fixed / scroll style to footer IF window tall enough
    if( cmxConfig.Custom.StaticFoot && $(window).height() > 600 ) {
        $('#siteFooter').addClass('w3-bottom');
        $('#siteContent').css('margin-bottom', footHt + 'px')
        $('#ows-Gull').css('bottom', footHt + 'px')
    } else {
        $('#siteFooter').removeClass('w3-bottom');
        $('#siteContent').css('margin-bottom', 0);
    }
    $('#siteContent').css('min-height', $(window).height() - (headHt + footHt) + 'px');
    //  Set the gull Z index
    if( cmxConfig.Gull.OnTop ) {
        $('#ows-Gull').css('z-index', 100 );    // On top
    } else {
        $('#ows-Gull').css('z-index', -100 );   // Underneath
    }
    $('[data-owsData').html('V:5.0.1');
}

let setViewOption = function( opt ) {
    //  FeelsLike / Apparent
    if( opt.useApparent == 1) {
        $('[data-cmx-Apparent]').removeClass('w3-hide');
        $('[data-cmx-FeelsLike').addClass('w3-hide')
    } else {
        $('[data-cmx-Apparent]').addClass('w3-hide');
        $('[data-cmx-FeelsLike]').removeClass('w3-hide');
    }
    //  Show/Hide ALL solar data
    if( opt.showSolar == 0 && opt.showUV == 0 ){
        $('data-cmx-NoSolar]').addClass('w3-hide');
    } else {
        if( opt.showSolar == 1 ) {
            $('[data-cmx-Solar]').removeClass('w3-hide');
        } else {
            $('[data-cmx-Solar]').addClass('w3-hide');
            $('[data-cmx-SolarGauge]').addClass('w3-hide');
        }
        if( opt.showUV == 1 ) {
            $('[data-cmx-UV]').removeClass('w3-hide');
        } else {
            $('[data-cmx-UVGauge]').addClass('w3-hide');
            $('[data-cmx-UV]').addClass('w3-hide');
        }
    }
}

//  Deal with window size changes
$(window).on('resize', function() {
    setPage();
});

//  Start the ball rolling
$().ready( function() {
    setPage();

    dataLoadedPromise = new Promise((myResolve, myReject) => {
        // Wait for data to be loaded
        $(function() {
            //setPage();
            getPageData(myResolve, myReject);
        });
    });
    animateGull();
    loadMoonImg();
});

//  Animate the Gull
let animateGull = function() {
    //  Set the gull hidden by default then reveal it.
    //console.log("Seagull animation called. " + cmxConfig.Seagull.Animation)
    var animation;
    switch( cmxConfig.Gull.Animation ) {
        case 'Grow': animation = 'gull-GrowUp '; break;
        case 'EnterRight': animation = 'gull-SlideIn-from-Right '; break;
        case 'EnterLeft': animation = 'gull-SlideIn-from-Left '; break;
        default: animation = 'gull-FadeIn ';
    }
    $('#ows-Gull').css('animation', animation + cmxConfig.Gull.Speed + 's');
};

function loadMoonImg() {
    //  Default location: dataPath + images/moon.png
    var dataPath = cmxConfig.Data;
    if(dataPath == '') {
        imgPath = dataPath;
    } else {
        dataPath += ( dataPath.at(-1) == '/' ? '' : '/');
    
        if( dataPath[0] == '/' ) {
            //  Its a root path
            imgPath = dataPath ; 
        } else {
            imgPath = location.pathname.split('/');
            imgPath.pop();  // Get rid of page name
            imgPath = imgPath.join('/') + '/' + dataPath ;
        }
    }
    $('#moonImg').attr('src', imgPath + 'images/moon.png');
}

let createMenus = function( stdMenu, src ) {
    var baseClass, btnClass;
    if( stdMenu ) {
        HTMLmenu = '<div class="w3-bar ows-theme0" style="grid-area:menu1;">\n';
        //console.log("Creating standard menu with " + HTMLmenu)
        baseClass = 'w3-bar-item w3-button ows-theme6-hvr w3-hide-small w3-hide-medium ';
        btnClass  = 'class="w3-button ows-theme5 ows-theme6-hvr w3-hide-small w3-hide-medium" onClick="toggleDD(this);" ';
        createMenu( 'Bar', src, false, '', baseClass, btnClass);
    }
    
    HTMLmenu = "";
    //console.log("Creating sidebar menu with: " + HTMLmenu);
    baseClass = 'w3-bar-item w3-button ows-theme6-hvr ';
    btnClass  = 'class="w3-button ows-theme5 ows-theme6-hvr" onClick="toggleDD(this)" ';
    createMenu( '', src, false, '', baseClass, btnClass)
    //  Add right carets
    $('.w3-dropdown-content').children('a').prepend('<i class="fa-solid fa-caret-right fa-sm"></i>&nbsp;&nbsp;');
    $('.ows-Accordion').children('a').prepend('<i class="fa-solid fa-caret-right fa-sm"></i>&nbsp;&nbsp;');
}

let createMenu = function( menu, src, dropDown, prefix, baseClass, btnClass ) {
    var target, icon, lnkClass;
    //console.log('Menu2 src: ' + JSON.stringify( src));
    src.forEach( function( item ) {
        icon = ( item.icon ? '<i class="' + item.icon + ' menuIcon"></i>' : '');
        if( item.subMenu ) {
            if( menu=="Bar") { icon = '';}
            HTMLmenu += '<div class="w3-dropdown-click">\n';
            HTMLmenu += '\t<button id="' + item.title.replaceAll(/ /g, '') + menu + '" ';
            HTMLmenu += btnClass ;
            HTMLmenu += 'aria-label="View ' + item.title + '" aria-expanded="false">' + item.title + ' ';// Space may not be required
            HTMLmenu += '<i class="fa-solid fa-caret-down fa-xs"></i>' + icon + '</button>';
            HTMLmenu += '\n\t<div id="dd' + item.title.replaceAll(/ /g, "") + menu + '" class="w3-dropdown-content w3-bar-block">\n';
            createMenu( menu, item.items, true, '\t\t', baseClass, btnClass);
            HTMLmenu += '\n\t</div>\n</div>\n';
        } else {
            //  Standard menu entries
            lnkClass = baseClass + (dropDown ? 'ows-theme4' : 'ows-theme5');    // Applies different colour if in a dropdown
            target = ( item.new_window ? ' target="_blank"' : '');
            switch(item.url) {
                case '#' :
                    if( item.forum && cmxData.forumurl != '') { // Its a forum link with a valid url
                        HTMLmenu += '<a href="' + cmxData.forumurl + '"' + target + ' class="' + lnkClass + '">' + item.title + '</a>\n';
                    }
                    if( item.webcam && cmxData.webcamurl != '') {   // A webcam link with a valid url
                        HTMLmenu += '<a href="' + cmxData.webcamurl + '"' + target + ' class="' + lnkClass + '">' + item.title + icon +'</a>\n';
                    }
                    break;
                default:
                    if( item.url === '' ){  // Replace with a dividing bar
                        HTMLmenu += '<div class="w3-bar-item mnuDivider"></div>\n';
                    } else {    // Insert basic link
                        HTMLmenu += '<a href="' + item.url + '"' + target + ' class="' + lnkClass + '" aria-label="View ' + item.title + '">' + item.title;
                        HTMLmenu += (cmxConfig.Custom.StandardMenu && !dropDown ? '' : icon) + '</a>\n';
                    }
            }
        }
    });
    if( dropDown ) { return; }
    if( menu=='Bar') {
        HTMLmenu += '<button class="w3-button ows-theme3 w3-hide-large" type="button" onClick="menuToggle()">&#9776;</button>'; // Add hamburger
        HTMLmenu += '\n</div>' ;    // Close html block
        //Insert into existing hamburger
         $( HTMLmenu ).replaceAll( '#hamburger' );
        //console.log("Bar menu: " + HTMLmenu + '\n\n')
    } else {
        HTMLmenu += '\n<div class="menuEnd ows-theme1 w3-bar-item" style="height:0.5vh; "></div>';
        // insert into menuSidebar
        $('#menuSidebar').append( HTMLmenu );
        //console.log("// Sidepanel Menu\n" + HTMLmenu + '\n\n')
    }
}

function addLeadingZeros(n) {
    return n <= 9 ? '0' + n : n;
}

function menuToggle() {
    if( $('#menuSidebar').css('display') == 'block') {
        $('#menuSidebar').css('animation','closeMenu 1s ease-in-out');
        setTimeout( function() {
            $('#menuSidebar' ).css('display', 'none').attr('aria-label', 'Open the menu');
        }, 900);
    } else {
        $('#menuSidebar').css('display', 'block').attr('aria-label', 'Close the menu');
        $('#menuSidebar').css('animation', 'openMenu 0.5s ease-in-out')
    }
}

function toggleDD( el )  {
    //  This controls the menu drop downs!
    if($('#dd' + el.id).css('display' ) == 'none') {
        //$('#menuSidebar').find('.w3-dropdown-content').css('display', 'none');
        //$('.w3-bar').find('.w3-dropdown-content').css('display', 'none')
        $('#dd' + el.id).css('display', 'block');
        $('#' + el.id).toggleClass('ows-theme5').toggleClass('ows-theme2');
    } else {
        $('#dd' + el.id).css('display', 'none');
        $('#' + el.id).toggleClass('ows-theme5').toggleClass('ows-theme2');
    }
}

function togglePopup( el ){
    //  This controls the popups
    $('#' + el).css( 'display', ($('#' + el).css('display') == 'none' ? 'block' : 'none'));
}
